/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl;

import de.unima.ki.anyburl.Settings;
import de.unima.ki.anyburl.data.TripleSet;
import de.unima.ki.anyburl.io.IOHelper;
import de.unima.ki.anyburl.structure.Dice;
import de.unima.ki.anyburl.structure.Rule;
import de.unima.ki.anyburl.threads.RuleWriterAsThread;
import de.unima.ki.anyburl.threads.Scorer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;

public class Learn {
    private static long timeStamp = 0L;
    private static String CONFIG_FILE = "config-learn.properties";
    private static HashSet<Integer> availableThreads = new HashSet();
    private static RuleWriterAsThread rwt = null;
    private static HashSet<Rule>[] rules307 = new HashSet[307];
    public static int[][] stats;
    public static Dice dice;
    public static boolean active;
    public static boolean report;
    public static boolean[] activeThread;
    public static boolean finished;

    static {
        int i = 0;
        while (i < 307) {
            HashSet anonymRuleSet = new HashSet();
            Learn.rules307[i] = new HashSet(Collections.synchronizedSet(anonymRuleSet));
            ++i;
        }
        active = true;
        report = false;
        finished = false;
    }

    public static void main(String[] args) throws FileNotFoundException, InterruptedException {
        block21: {
            if (args.length == 1) {
                CONFIG_FILE = args[0];
                System.out.println("reading params from file " + CONFIG_FILE);
            }
            Properties prop = new Properties();
            FileInputStream input = null;
            try {
                try {
                    input = new FileInputStream(CONFIG_FILE);
                    prop.load(input);
                    Settings.SAFE_PREFIX_MODE = IOHelper.getProperty(prop, "SAFE_PREFIX_MODE", Settings.SAFE_PREFIX_MODE);
                    Settings.SINGLE_RELATIONS = IOHelper.getProperty(prop, "SINGLE_RELATIONS", Settings.SINGLE_RELATIONS);
                    Settings.PATH_TRAINING = IOHelper.getProperty(prop, "PATH_TRAINING", Settings.PATH_TRAINING);
                    Settings.CONSTANTS_OFF = IOHelper.getProperty(prop, "CONSTANTS_OFF", Settings.CONSTANTS_OFF);
                    Settings.PATH_OUTPUT = IOHelper.getProperty(prop, "PATH_OUTPUT", Settings.PATH_OUTPUT);
                    Settings.PATH_DICE = IOHelper.getProperty(prop, "PATH_DICE", Settings.PATH_DICE);
                    Settings.SNAPSHOTS_AT = IOHelper.getProperty(prop, "SNAPSHOTS_AT", Settings.SNAPSHOTS_AT);
                    Settings.SAMPLE_SIZE = IOHelper.getProperty(prop, "SAMPLE_SIZE", Settings.SAMPLE_SIZE);
                    Settings.TRIAL_SIZE = IOHelper.getProperty(prop, "TRIAL_SIZE", Settings.TRIAL_SIZE);
                    Settings.BATCH_TIME = IOHelper.getProperty(prop, "BATCH_TIME", Settings.BATCH_TIME);
                    Settings.WORKER_THREADS = IOHelper.getProperty(prop, "WORKER_THREADS", Settings.WORKER_THREADS);
                    Settings.ZERO_RULES_ACTIVE = IOHelper.getProperty(prop, "ZERO_RULES_ACTIVE", Settings.ZERO_RULES_ACTIVE);
                    Settings.MAX_LENGTH_CYCLIC = IOHelper.getProperty(prop, "MAX_LENGTH_CYCLIC", Settings.MAX_LENGTH_CYCLIC);
                    Settings.MAX_LENGTH_ACYCLIC = IOHelper.getProperty(prop, "MAX_LENGTH_ACYCLIC", Settings.MAX_LENGTH_ACYCLIC);
                    Settings.THRESHOLD_CORRECT_PREDICTIONS = IOHelper.getProperty(prop, "THRESHOLD_CORRECT_PREDICTIONS", Settings.THRESHOLD_CORRECT_PREDICTIONS);
                    Settings.THRESHOLD_CORRECT_PREDICTIONS_ZERO = IOHelper.getProperty(prop, "THRESHOLD_CORRECT_PREDICTIONS_ZERO", Settings.THRESHOLD_CORRECT_PREDICTIONS_ZERO);
                    Settings.THRESHOLD_CONFIDENCE = IOHelper.getProperty(prop, "THRESHOLD_CONFIDENCE", Settings.THRESHOLD_CONFIDENCE);
                    Settings.EPSILON = IOHelper.getProperty(prop, "EPSILON", Settings.EPSILON);
                    Settings.SPECIALIZATION_CI = IOHelper.getProperty(prop, "SPECIALIZATION_CI", Settings.SPECIALIZATION_CI);
                    Settings.REWARD = IOHelper.getProperty(prop, "SCORING_REGIME", Settings.REWARD);
                    Settings.POLICY = IOHelper.getProperty(prop, "POLICY", Settings.POLICY);
                    Settings.MAX_LENGTH_GROUNDED_CYCLIC = IOHelper.getProperty(prop, "MAX_LENGTH_GROUNDED_CYCLIC", Settings.MAX_LENGTH_GROUNDED_CYCLIC);
                    Settings.AC_MIN_NUM_OF_LAST_ATOM_GROUNDINGS = IOHelper.getProperty(prop, "AC_MIN_NUM_OF_LAST_ATOM_GROUNDINGS", Settings.AC_MIN_NUM_OF_LAST_ATOM_GROUNDINGS);
                    Settings.BEAM_SAMPLING_MAX_BODY_GROUNDINGS = IOHelper.getProperty(prop, "BEAM_SAMPLING_MAX_BODY_GROUNDINGS", Settings.BEAM_SAMPLING_MAX_BODY_GROUNDINGS);
                    Settings.BEAM_SAMPLING_MAX_BODY_GROUNDING_ATTEMPTS = IOHelper.getProperty(prop, "BEAM_SAMPLING_MAX_BODY_GROUNDING_ATTEMPTS", Settings.BEAM_SAMPLING_MAX_BODY_GROUNDING_ATTEMPTS);
                    Settings.BEAM_SAMPLING_MAX_REPETITIONS = IOHelper.getProperty(prop, "BEAM_SAMPLING_MAX_REPETITIONS", Settings.BEAM_SAMPLING_MAX_REPETITIONS);
                    Settings.RULE_AC2_WEIGHT = IOHelper.getProperty(prop, "RULE_AC2_WEIGHT", Settings.RULE_AC2_WEIGHT);
                    Settings.RULE_ZERO_WEIGHT = IOHelper.getProperty(prop, "RULE_ZERO_WEIGHT", Settings.RULE_ZERO_WEIGHT);
                    Settings.REWRITE_REFLEXIV = IOHelper.getProperty(prop, "REWRITE_REFLEXIV", Settings.REWRITE_REFLEXIV);
                    Settings.EXCLUDE_AC2_RULES = IOHelper.getProperty(prop, "EXCLUDE_AC2_RULES", Settings.EXCLUDE_AC2_RULES);
                }
                catch (IOException ex) {
                    System.err.println("Could not read relevant parameters from the config file " + CONFIG_FILE);
                    ex.printStackTrace();
                    System.exit(1);
                    if (input != null) {
                        try {
                            ((InputStream)input).close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            System.exit(1);
                        }
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
                throw throwable;
            }
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
        }
        DecimalFormat df = new DecimalFormat("000000.00");
        PrintWriter log = new PrintWriter(String.valueOf(Settings.PATH_OUTPUT) + "_log");
        log.println("Logfile");
        log.println("~~~~~~~\n");
        long indexStartTime = System.currentTimeMillis();
        TripleSet ts = new TripleSet(Settings.PATH_TRAINING, true);
        ts.setupListStructure();
        ts.precomputeNRandomEntitiesPerRelation(Settings.BEAM_SAMPLING_MAX_BODY_GROUNDING_ATTEMPTS);
        System.out.println(" done.");
        long indexEndTime = System.currentTimeMillis();
        log.println("indexing dataset: " + Settings.PATH_TRAINING);
        log.println("time elapsed: " + (indexEndTime - indexStartTime) + "ms");
        log.println();
        log.println(IOHelper.getParams());
        log.flush();
        long now = System.currentTimeMillis();
        dice = new Dice(Settings.PATH_DICE);
        dice.computeRelevenatScores();
        dice.saveScores();
        activeThread = new boolean[Settings.WORKER_THREADS];
        stats = new int[Settings.WORKER_THREADS][3];
        Thread[] scorer = new Scorer[Settings.WORKER_THREADS];
        int threadCounter = 0;
        while (threadCounter < Settings.WORKER_THREADS) {
            Thread.sleep(50L);
            System.out.println("* creating worker thread #" + threadCounter);
            Scorer s = new Scorer(ts, threadCounter);
            int type = dice.ask(0);
            boolean zero = Dice.decodedDiceZero(type);
            boolean cyclic = Dice.decodedDiceCyclic(type);
            boolean acyclic = Dice.decodedDiceAcyclic(type);
            int len = Dice.decodedDiceLength(type);
            s.setSearchParameters(zero, cyclic, acyclic, len);
            scorer[threadCounter] = s;
            scorer[threadCounter].start();
            Learn.activeThread[threadCounter] = true;
            ++threadCounter;
        }
        dice.resetScores();
        boolean done = false;
        int batchCounter = 0;
        long startTime = System.currentTimeMillis();
        int snapshotIndex = 0;
        long batchStart = System.currentTimeMillis();
        while (!done) {
            Thread.sleep(10L);
            now = System.currentTimeMillis();
            int elapsedSeconds = (int)(now - startTime) / 1000;
            int currentIndex = snapshotIndex;
            snapshotIndex = Learn.checkTimeMaybeStoreRules(log, done, snapshotIndex, elapsedSeconds, dice);
            if (snapshotIndex > currentIndex) {
                batchStart = System.currentTimeMillis();
                now = System.currentTimeMillis();
            }
            if (now - batchStart <= (long)Settings.BATCH_TIME) continue;
            report = true;
            active = false;
            do {
                Thread.sleep(10L);
            } while (!Learn.allThreadsReported());
            ++batchCounter;
            dice.computeRelevenatScores();
            dice.saveScores();
            int numOfRules = 0;
            int i = 0;
            while (i < 307) {
                numOfRules += rules307[i].size();
                ++i;
            }
            int t = 0;
            while (t < scorer.length) {
                int type = dice.ask(batchCounter);
                boolean zero = Dice.decodedDiceZero(type);
                boolean cyclic = Dice.decodedDiceCyclic(type);
                boolean acyclic = Dice.decodedDiceAcyclic(type);
                int len = Dice.decodedDiceLength(type);
                ((Scorer)scorer[t]).setSearchParameters(zero, cyclic, acyclic, len);
                ++t;
            }
            System.out.println(dice);
            dice.resetScores();
            Learn.activateAllThreads(scorer);
            batchStart = System.currentTimeMillis();
            active = true;
            report = false;
        }
        log.flush();
        log.close();
    }

    private static int checkTimeMaybeStoreRules(PrintWriter log, boolean done, int snapshotIndex, int elapsedSeconds, Dice dice) {
        if (elapsedSeconds > Settings.SNAPSHOTS_AT[snapshotIndex] || done) {
            active = false;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            if (!done) {
                System.out.println("\n>>> CREATING SNAPSHOT " + snapshotIndex + " after " + elapsedSeconds + " seconds");
            } else {
                System.out.println("\n>>> CREATING FINAL SNAPSHOT 0 after " + elapsedSeconds + " seconds");
            }
            String suffix = "" + (done ? 0 : Settings.SNAPSHOTS_AT[snapshotIndex]);
            rwt = new RuleWriterAsThread(Settings.PATH_OUTPUT, done ? 0 : Settings.SNAPSHOTS_AT[snapshotIndex], rules307, log, elapsedSeconds);
            rwt.start();
            System.out.println();
            dice.write(suffix);
            if (++snapshotIndex == Settings.SNAPSHOTS_AT.length || done) {
                log.close();
                System.out.println(">>> Bye, bye.");
                finished = true;
                while (rwt != null && rwt.isAlive()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    System.out.println(">>> waiting for rule writer thread to finish");
                }
                System.exit(1);
            }
            active = true;
        }
        return snapshotIndex;
    }

    public static void printStatsOfBatch() {
        int i = 0;
        while (i < stats.length) {
            System.out.print("Worker #" + i + ": ");
            int j = 0;
            while (j < stats[i].length - 1) {
                System.out.print(String.valueOf(stats[i][j]) + " / ");
                ++j;
            }
            System.out.println(stats[i][stats[i].length - 1]);
            ++i;
        }
    }

    public static double getSaturationOfBatch() {
        int storedTotal = 0;
        int createdTotal = 0;
        int i = 0;
        while (i < stats.length) {
            storedTotal += stats[i][0];
            createdTotal += stats[i][1];
            ++i;
        }
        return 1.0 - (double)storedTotal / (double)createdTotal;
    }

    public static boolean active(int threadId, int storedRules, int createdRules, double producedScore, boolean zero, boolean cyclic, boolean acyclic, int len) {
        if (active) {
            return true;
        }
        if (!report) {
            return true;
        }
        if (activeThread[threadId]) {
            int type = Dice.encode(zero, cyclic, acyclic, len);
            Learn.stats[threadId][0] = storedRules;
            Learn.stats[threadId][1] = createdRules;
            dice.addScore(type, producedScore);
            Learn.activeThread[threadId] = false;
            return false;
        }
        return false;
    }

    public static boolean allThreadsReported() {
        int i = 0;
        while (i < activeThread.length) {
            if (activeThread[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void activateAllThreads(Thread[] scorer) {
        int i = 0;
        while (i < activeThread.length) {
            Learn.activeThread[i] = true;
            ++i;
        }
        active = true;
    }

    public static void showElapsedMoreThan(long duration, String message) {
        long now = System.currentTimeMillis();
        long elapsed = now - timeStamp;
        if (elapsed > duration) {
            System.err.println(String.valueOf(message) + " required " + elapsed + " millis!");
        }
    }

    public static void takeTime() {
        timeStamp = System.currentTimeMillis();
    }

    public static void storeRule(Rule rule) {
        int code307 = Math.abs(rule.hashCode()) % 307;
        rules307[code307].add(rule);
    }

    public static boolean isStored(Rule rule) {
        int code307 = Math.abs(rule.hashCode()) % 307;
        return !rules307[code307].contains(rule);
    }

    public static boolean areAllThere() {
        return availableThreads.size() == Settings.WORKER_THREADS;
    }

    public static void heyYouImHere(int id) {
        availableThreads.add(id);
    }
}

