/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.data;

import de.unima.ki.anyburl.Settings;

public class Triple {
    public boolean invalid = false;
    private String head;
    private String tail;
    private String relation;
    private int h = 0;
    private boolean h_set = false;
    private static int ignoreCounter = 0;
    private static int ignoreMaxDisplay = 0;

    public Triple(String head, String relation, String tail) {
        if (head.length() < 2 || tail.length() < 2) {
            if (ignoreCounter < ignoreMaxDisplay) {
                System.err.println("the triple set you are trying to load contains constants of length 1 ... a constant (entity) needs to be described by at least two letters");
                System.err.println("ignoring: " + head + " " + relation + " " + tail);
                ++ignoreCounter;
            }
            this.invalid = true;
        }
        this.head = head;
        this.relation = relation;
        this.tail = Settings.REWRITE_REFLEXIV && head.equals(tail) ? "me_myself_i" : tail;
    }

    public static Triple createTriple(String head, String relation, String tail, boolean reverse) {
        if (reverse) {
            return new Triple(tail, relation, head);
        }
        return new Triple(head, relation, tail);
    }

    public String getHead() {
        return this.head;
    }

    public String getTail() {
        return this.tail;
    }

    public String getValue(boolean headNotTail) {
        if (headNotTail) {
            return this.head;
        }
        return this.tail;
    }

    public String getRelation() {
        return this.relation;
    }

    public String toString() {
        return String.valueOf(this.head) + " " + this.relation + " " + this.tail;
    }

    public boolean equals(Object that) {
        if (that instanceof Triple) {
            Triple thatTriple = (Triple)that;
            if (this.head.equals(thatTriple.head) && this.tail.equals(thatTriple.tail) && this.relation.equals(thatTriple.relation)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (!this.h_set) {
            this.h = this.head.hashCode() + this.tail.hashCode() + this.relation.hashCode();
        }
        return this.h;
    }

    public boolean equals(boolean headNotTail, String subject, String rel, String object) {
        if (headNotTail) {
            return this.head.equals(subject) && this.tail.equals(object) && this.relation.equals(rel);
        }
        return this.head.equals(object) && this.tail.equals(subject) && this.relation.equals(rel);
    }

    public double getConfidence() {
        return 1.0;
    }

    public String getSubstitution(String constant, String variable) {
        String t = this.tail.equals(constant) ? variable : this.tail;
        String h = this.head.equals(constant) ? variable : this.head;
        return String.valueOf(this.relation) + "(" + h + "," + t + ")";
    }

    public String getSubstitution(String constant, String variable, String otherVariable) {
        String h;
        String t = this.tail.equals(constant) ? variable : this.tail;
        String string = h = this.head.equals(constant) ? variable : this.head;
        if (t.equals(variable)) {
            h = otherVariable;
        }
        if (h.equals(variable)) {
            t = otherVariable;
        }
        return String.valueOf(this.relation) + "(" + h + "," + t + ")";
    }
}

