/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.data;

import de.unima.ki.anyburl.Settings;
import de.unima.ki.anyburl.data.Triple;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class TripleSet {
    private ArrayList<Triple> triples;
    private Random rand;
    HashMap<String, ArrayList<Triple>> headToList;
    HashMap<String, ArrayList<Triple>> tailToList;
    HashMap<String, ArrayList<Triple>> relationToList;
    HashMap<String, HashMap<String, HashSet<String>>> headRelation2TailSet;
    HashMap<String, HashMap<String, HashSet<String>>> tailRelation2HeadSet;
    HashMap<String, HashMap<String, ArrayList<String>>> headRelation2TailList;
    HashMap<String, HashMap<String, ArrayList<String>>> tailRelation2HeadList;
    HashSet<String> frequentRelations = new HashSet();
    HashMap<String, ArrayList<String>> relation2HeadSample = new HashMap();
    HashMap<String, ArrayList<String>> relation2TailSample = new HashMap();

    public static void main(String[] args) {
    }

    public TripleSet(String filepath) {
        this();
        this.readTriples(filepath, true);
        this.indexTriples();
    }

    public TripleSet(String filepath, boolean ignore4Plus) {
        this();
        this.readTriples(filepath, ignore4Plus);
        this.indexTriples();
    }

    public TripleSet() {
        this.rand = new Random();
        this.triples = new ArrayList();
        this.headToList = new HashMap();
        this.tailToList = new HashMap();
        this.relationToList = new HashMap();
        this.headRelation2TailSet = new HashMap();
        this.tailRelation2HeadSet = new HashMap();
        this.headRelation2TailList = new HashMap();
        this.tailRelation2HeadList = new HashMap();
    }

    public void addTripleSet(TripleSet ts) {
        for (Triple t : ts.triples) {
            this.addTriple(t);
        }
    }

    public void addTriples(ArrayList<Triple> triples) {
        for (Triple t : triples) {
            this.addTriple(t);
        }
    }

    public void addTriple(Triple t) {
        if (this.isTrue(t)) {
            return;
        }
        if (!t.invalid) {
            this.triples.add(t);
        }
        if (!t.invalid) {
            this.addTripleToIndex(t);
        }
    }

    private void indexTriples() {
        long tCounter = 0L;
        long divisor = 10000L;
        for (Triple t : this.triples) {
            if (++tCounter % divisor == 0L) {
                System.out.println("* indexed " + tCounter + " triples");
                divisor *= 2L;
            }
            this.addTripleToIndex(t);
        }
        System.out.println("* set up index for " + this.relationToList.keySet().size() + " relations, " + this.headToList.keySet().size() + " head entities, and " + this.tailToList.keySet().size() + " tail entities");
    }

    public void setupListStructure() {
        System.out.print("* set up list structure for randomized access searches uring rule learning ... ");
        for (String head : this.headRelation2TailSet.keySet()) {
            this.headRelation2TailList.put(head, new HashMap());
            for (String relation : this.headRelation2TailSet.get(head).keySet()) {
                if (this.headRelation2TailSet.get(head).get(relation).size() <= 10) continue;
                this.headRelation2TailList.get(head).put(relation, new ArrayList(this.headRelation2TailSet.get(head).get(relation).size()));
                this.headRelation2TailList.get(head).get(relation).addAll((Collection<String>)this.headRelation2TailSet.get(head).get(relation));
                this.sampleSubset(this.headRelation2TailList.get(head).get(relation));
            }
        }
        for (String tail : this.tailRelation2HeadSet.keySet()) {
            this.tailRelation2HeadList.put(tail, new HashMap());
            for (String relation : this.tailRelation2HeadSet.get(tail).keySet()) {
                if (this.tailRelation2HeadSet.get(tail).get(relation).size() <= 10) continue;
                this.tailRelation2HeadList.get(tail).put(relation, new ArrayList(this.tailRelation2HeadSet.get(tail).get(relation).size()));
                this.tailRelation2HeadList.get(tail).get(relation).addAll((Collection<String>)this.tailRelation2HeadSet.get(tail).get(relation));
                this.sampleSubset(this.tailRelation2HeadList.get(tail).get(relation));
            }
        }
        System.out.println(" done");
    }

    private void sampleSubset(ArrayList<String> list) {
        Collections.shuffle(list);
        while (list.size() > 5000) {
            list.remove(list.size() - 1);
        }
    }

    private void addTripleToIndex(Triple t) {
        String head = t.getHead();
        String tail = t.getTail();
        String relation = t.getRelation();
        if (!this.headToList.containsKey(head)) {
            this.headToList.put(head, new ArrayList());
        }
        this.headToList.get(head).add(t);
        if (!this.tailToList.containsKey(tail)) {
            this.tailToList.put(tail, new ArrayList());
        }
        this.tailToList.get(tail).add(t);
        if (!this.relationToList.containsKey(relation)) {
            this.relationToList.put(relation, new ArrayList());
        }
        this.relationToList.get(relation).add(t);
        if (!this.headRelation2TailSet.containsKey(head)) {
            this.headRelation2TailSet.put(head, new HashMap());
        }
        if (!this.headRelation2TailSet.get(head).containsKey(relation)) {
            this.headRelation2TailSet.get(head).put(relation, new HashSet());
        }
        this.headRelation2TailSet.get(head).get(relation).add(tail);
        if (!this.tailRelation2HeadSet.containsKey(tail)) {
            this.tailRelation2HeadSet.put(tail, new HashMap());
        }
        if (!this.tailRelation2HeadSet.get(tail).containsKey(relation)) {
            this.tailRelation2HeadSet.get(tail).put(relation, new HashSet());
        }
        this.tailRelation2HeadSet.get(tail).get(relation).add(head);
    }

    private void readTriples(String filepath, boolean ignore4Plus) {
        Path file = new File(filepath).toPath();
        Charset charset = Charset.forName("UTF8");
        String line = null;
        long lineCounter = 0L;
        try {
            Throwable throwable = null;
            Object var12_10 = null;
            try (BufferedReader reader = Files.newBufferedReader(file, charset);){
                while ((line = reader.readLine()) != null) {
                    String o;
                    String r;
                    String s;
                    if (++lineCounter % 1000000L == 0L) {
                        System.out.println(">>> parsed " + lineCounter + " lines");
                    }
                    if (line.length() <= 2) continue;
                    String[] token = line.split("\t");
                    if (token.length < 3) {
                        token = line.split(" ");
                    }
                    Triple t = null;
                    if (Settings.SAFE_PREFIX_MODE) {
                        s = ("e" + token[0]).intern();
                        r = ("r" + token[1]).intern();
                        o = ("e" + token[2]).intern();
                    } else {
                        s = token[0].intern();
                        r = token[1].intern();
                        o = token[2].intern();
                    }
                    if (token.length == 3) {
                        t = new Triple(s, r, o);
                    }
                    if (token.length != 3 && ignore4Plus) {
                        t = new Triple(s, r, o);
                    }
                    if (token.length == 4 && !ignore4Plus) {
                        if (token[3].equals(".")) {
                            t = new Triple(s, r, o);
                        } else {
                            System.err.println("could not parse line " + line);
                            t = null;
                        }
                    }
                    if (token.length == 5 && !ignore4Plus) {
                        String subject = token[0];
                        String relation = token[1];
                        String object = token[2];
                        subject = subject.replace(" ", "_");
                        relation = relation.replace(" ", "_");
                        object = object.replace(" ", "_");
                        t = new Triple(subject, relation, object);
                    }
                    if (t == null) continue;
                    if (!t.invalid) {
                        this.triples.add(t);
                    }
                    if (!Settings.REWRITE_REFLEXIV || !t.getTail().equals("me_myself_i")) continue;
                    Triple trev = new Triple(t.getTail(), t.getRelation(), t.getHead());
                    if (trev.invalid) continue;
                    this.triples.add(trev);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException x) {
            System.err.format("IOException: %s%n", x);
            System.err.format("Error occured for line: " + line + " LINE END", new Object[0]);
        }
        System.out.println("* read " + this.triples.size() + " triples");
    }

    public ArrayList<Triple> getTriples() {
        return this.triples;
    }

    public ArrayList<Triple> getTriplesByHead(String head) {
        if (this.headToList.containsKey(head)) {
            return this.headToList.get(head);
        }
        return new ArrayList<Triple>();
    }

    public ArrayList<Triple> getTriplesByHeadNotTail(String headOrTail, boolean byHeadNotTail) {
        if (byHeadNotTail) {
            return this.getTriplesByHead(headOrTail);
        }
        return this.getTriplesByTail(headOrTail);
    }

    public ArrayList<Triple> getNTriplesByHead(String head, int n) {
        if (this.headToList.containsKey(head)) {
            if (this.headToList.get(head).size() <= n) {
                return this.headToList.get(head);
            }
            ArrayList<Triple> chosen = new ArrayList<Triple>();
            int i = 0;
            while (i < n) {
                int index = this.rand.nextInt(this.headToList.get(head).size());
                chosen.add(this.headToList.get(head).get(index));
                ++i;
            }
            return chosen;
        }
        return new ArrayList<Triple>();
    }

    public ArrayList<Triple> getTriplesByTail(String tail) {
        if (this.tailToList.containsKey(tail)) {
            return this.tailToList.get(tail);
        }
        return new ArrayList<Triple>();
    }

    public ArrayList<Triple> getNTriplesByTail(String tail, int n) {
        if (this.tailToList.containsKey(tail)) {
            if (this.tailToList.get(tail).size() <= n) {
                return this.tailToList.get(tail);
            }
            ArrayList<Triple> chosen = new ArrayList<Triple>();
            int i = 0;
            while (i < n) {
                int index = this.rand.nextInt(this.tailToList.get(tail).size());
                chosen.add(this.tailToList.get(tail).get(index));
                ++i;
            }
            return chosen;
        }
        return new ArrayList<Triple>();
    }

    public ArrayList<Triple> getTriplesByRelation(String relation) {
        if (this.relationToList.containsKey(relation)) {
            return this.relationToList.get(relation);
        }
        return new ArrayList<Triple>();
    }

    public Triple getRandomTripleByRelation(String relation) {
        if (this.relationToList.containsKey(relation)) {
            return this.relationToList.get(relation).get(this.rand.nextInt(this.relationToList.get(relation).size()));
        }
        return null;
    }

    public ArrayList<String> getNRandomEntitiesByRelation(String relation, boolean headNotTail, int n) {
        if (headNotTail) {
            if (this.relation2HeadSample.containsKey(relation)) {
                return this.relation2HeadSample.get(relation);
            }
        } else if (this.relation2TailSample.containsKey(relation)) {
            return this.relation2TailSample.get(relation);
        }
        return this.computeNRandomEntitiesByRelation(relation, headNotTail, n);
    }

    public void precomputeNRandomEntitiesPerRelation(int n) {
        System.out.print("* precomputing random starting points for each relation/direction for the beam search ...");
        for (String relation : this.getRelations()) {
            this.computeNRandomEntitiesByRelation(relation, true, n);
            this.computeNRandomEntitiesByRelation(relation, false, n);
        }
    }

    private synchronized ArrayList<String> computeNRandomEntitiesByRelation(String relation, boolean headNotTail, int n) {
        if (this.relationToList.containsKey(relation)) {
            ArrayList<String> entities = new ArrayList<String>();
            HashSet<String> entitiesAsSet = new HashSet<String>();
            for (Triple triple : this.relationToList.get(relation)) {
                String value = triple.getValue(headNotTail);
                if (entitiesAsSet.contains(value)) continue;
                entitiesAsSet.add(value);
                entities.add(value);
            }
            ArrayList<String> sampledEntities = new ArrayList<String>();
            int i = 0;
            while (i < n) {
                String entity = (String)entities.get(this.rand.nextInt(entities.size()));
                sampledEntities.add(entity);
                ++i;
            }
            if (headNotTail) {
                this.relation2HeadSample.put(relation, sampledEntities);
            } else {
                this.relation2TailSample.put(relation, sampledEntities);
            }
            return sampledEntities;
        }
        System.err.println("something is strange, internal reference to relation " + relation + ", which is not indexed");
        System.err.println("check if rule set and triple set fit together");
        return null;
    }

    public ArrayList<String> selectNRandomEntitiesByRelation(String relation, boolean headNotTail, int n) {
        if (this.relationToList.containsKey(relation)) {
            ArrayList<String> entities = new ArrayList<String>();
            int j = 0;
            for (Triple triple : this.relationToList.get(relation)) {
                String value = triple.getValue(headNotTail);
                entities.add(value);
                if (++j == n) break;
            }
            ArrayList<String> sampledEntities = new ArrayList<String>();
            int i = 0;
            while (i < n) {
                String entity = (String)entities.get(this.rand.nextInt(entities.size()));
                sampledEntities.add(entity);
                ++i;
            }
            return sampledEntities;
        }
        System.err.println("something is strange, internal reference to relation " + relation + ", which is not indexed");
        System.err.println("check if rule set and triple set fit together");
        return null;
    }

    public Set<String> getRelations() {
        return this.relationToList.keySet();
    }

    public Set<String> getHeadEntities(String relation, String tail) {
        if (this.tailRelation2HeadSet.get(tail) != null && this.tailRelation2HeadSet.get(tail).get(relation) != null) {
            return this.tailRelation2HeadSet.get(tail).get(relation);
        }
        return new HashSet<String>();
    }

    public Set<String> getTailEntities(String relation, String head) {
        if (this.headRelation2TailSet.get(head) != null && this.headRelation2TailSet.get(head).get(relation) != null) {
            return this.headRelation2TailSet.get(head).get(relation);
        }
        return new HashSet<String>();
    }

    public Set<String> getEntities(String relation, String value, boolean headNotTail) {
        if (headNotTail) {
            return this.getTailEntities(relation, value);
        }
        return this.getHeadEntities(relation, value);
    }

    public String getRandomEntity(String relation, String value, boolean headNotTail) {
        if (headNotTail) {
            return this.getRandomTailEntity(relation, value);
        }
        return this.getRandomHeadEntity(relation, value);
    }

    private String getRandomHeadEntity(String relation, String tail) {
        if (!this.tailRelation2HeadList.containsKey(tail)) {
            return null;
        }
        ArrayList<String> list = this.tailRelation2HeadList.get(tail).get(relation);
        if (list == null) {
            if (this.tailRelation2HeadSet.get(tail).get(relation) != null && this.tailRelation2HeadSet.get(tail).get(relation).size() > 0) {
                list = new ArrayList();
                list.addAll((Collection<String>)this.tailRelation2HeadSet.get(tail).get(relation));
            } else {
                return null;
            }
        }
        return list.get(this.rand.nextInt(list.size()));
    }

    private String getRandomTailEntity(String relation, String head) {
        if (!this.headRelation2TailList.containsKey(head)) {
            return null;
        }
        ArrayList<String> list = this.headRelation2TailList.get(head).get(relation);
        if (list == null) {
            if (this.headRelation2TailSet.get(head).get(relation) != null && this.headRelation2TailSet.get(head).get(relation).size() > 0) {
                list = new ArrayList();
                list.addAll((Collection<String>)this.headRelation2TailSet.get(head).get(relation));
            } else {
                return null;
            }
        }
        return list.get(this.rand.nextInt(list.size()));
    }

    public boolean isTrue(String head, String relation, String tail) {
        if (this.tailRelation2HeadSet.get(tail) != null && this.tailRelation2HeadSet.get(tail).get(relation) != null) {
            return this.tailRelation2HeadSet.get(tail).get(relation).contains(head);
        }
        return false;
    }

    public boolean isTrue(Triple triple) {
        return this.isTrue(triple.getHead(), triple.getRelation(), triple.getTail());
    }

    public void compareTo(TripleSet that, String thisId, String thatId) {
        System.out.println("* Comparing two triple sets");
        int counter = 0;
        for (Triple t : this.triples) {
            if (!that.isTrue(t)) continue;
            ++counter;
        }
        System.out.println("* size of " + thisId + ": " + this.triples.size());
        System.out.println("* size of " + thatId + ": " + that.triples.size());
        System.out.println("* size of intersection: " + counter);
    }

    public TripleSet getIntersectionWith(TripleSet that) {
        TripleSet ts = new TripleSet();
        for (Triple t : this.triples) {
            if (!that.isTrue(t)) continue;
            ts.addTriple(t);
        }
        return ts;
    }

    public TripleSet minus(TripleSet that) {
        TripleSet ts = new TripleSet();
        for (Triple t : this.triples) {
            if (that.isTrue(t)) continue;
            ts.addTriple(t);
        }
        return ts;
    }

    public int getNumOfEntities() {
        return this.headToList.keySet().size() + this.tailToList.keySet().size();
    }

    public void determineFrequentRelations(double coverage) {
        HashMap<String, Integer> relationCounter = new HashMap<String, Integer>();
        int allCounter = 0;
        for (Triple t : this.triples) {
            ++allCounter;
            String r = t.getRelation();
            if (relationCounter.containsKey(r)) {
                int count = (Integer)relationCounter.get(r);
                relationCounter.put(r, count + 1);
                continue;
            }
            relationCounter.put(r, 1);
        }
        ArrayList counts = new ArrayList();
        counts.addAll(relationCounter.values());
        Collections.sort(counts);
        int countUp = 0;
        int border = 0;
        for (Integer c : counts) {
            if (!((double)(allCounter - (countUp += c.intValue())) / (double)allCounter < coverage)) continue;
            border = c;
            break;
        }
        for (String r : relationCounter.keySet()) {
            if ((Integer)relationCounter.get(r) <= border) continue;
            this.frequentRelations.add(r);
        }
    }

    public boolean isFrequentRelation(String relation) {
        return this.frequentRelations.contains(relation);
    }

    public Set<String> getEntities() {
        HashSet<String> entities = new HashSet<String>();
        entities.addAll(this.headToList.keySet());
        entities.addAll(this.tailToList.keySet());
        return entities;
    }

    public void write(String filepath) throws FileNotFoundException {
        PrintWriter pw = new PrintWriter(filepath);
        for (Triple t : this.triples) {
            pw.println(t);
        }
        pw.flush();
        pw.close();
    }

    public int size() {
        return this.triples.size();
    }
}

