/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.eval;

import de.unima.ki.anyburl.data.Triple;
import de.unima.ki.anyburl.data.TripleSet;
import de.unima.ki.anyburl.eval.AlternativeMentions;
import de.unima.ki.anyburl.eval.GoldStandard;
import de.unima.ki.anyburl.eval.HitsAtK;
import de.unima.ki.anyburl.eval.ResultSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;

public class ComparativeEvaluation {
    public static String[] categories = new String[]{"Symmetry", "Equivalence", "Subsumption", "Path", "Not covered"};
    public static String target = "CODEX-L";
    public static int ALL_HEAD_TAIL = 0;
    public static HashSet<String> RELATION_FILTER = new HashSet();

    public static void main(String[] args) throws IOException {
        TripleSet trainingSet = null;
        TripleSet validationSet = null;
        TripleSet testSet = null;
        AlternativeMentions am = null;
        GoldStandard gold = null;
        if (target.equals("CODEX-S")) {
            trainingSet = new TripleSet("data/CODEX/S/train.txt");
            validationSet = new TripleSet("data/CODEX/S/valid.txt");
            testSet = new TripleSet("data/CODEX/S/test.txt");
            gold = null;
        }
        if (target.equals("CODEX-M")) {
            trainingSet = new TripleSet("data/CODEX/M/train.txt");
            validationSet = new TripleSet("data/CODEX/M/valid.txt");
            testSet = new TripleSet("data/CODEX/M/test.txt");
            gold = null;
        }
        if (target.equals("CODEX-L")) {
            trainingSet = new TripleSet("data/CODEX/L/train.txt");
            validationSet = new TripleSet("data/CODEX/L/valid.txt");
            testSet = new TripleSet("data/CODEX/L/test.txt");
            gold = null;
        }
        if (target.equals("DIANA")) {
            trainingSet = new TripleSet("exp/diana/train.txt");
            validationSet = new TripleSet("exp/diana/valid.txt");
            testSet = new TripleSet("exp/diana/test.txt");
            gold = null;
        }
        if (target.equals("NUMBERS")) {
            trainingSet = new TripleSet("../KBCTestdataGenerator/data/numbers-d3-08-p08-p04-p00-uc/train.txt");
            validationSet = new TripleSet("../KBCTestdataGenerator/data/numbers-d3-08-p08-p04-p00-uc/valid.txt");
            testSet = new TripleSet("../KBCTestdataGenerator/data/numbers-d3-08-p08-p04-p00-uc/test.txt");
            gold = null;
        }
        if (target.equals("WN18")) {
            trainingSet = new TripleSet("data/WN18/train.txt");
            validationSet = new TripleSet("data/WN18/valid.txt");
            testSet = new TripleSet("data/WN18/test.txt");
            gold = new GoldStandard("data/WN18/gold.txt");
        }
        if (target.equals("FB15")) {
            trainingSet = new TripleSet("data/FB15k/train.txt");
            validationSet = new TripleSet("data/FB15k/valid.txt");
            testSet = new TripleSet("data/FB15k/test.txt");
            gold = new GoldStandard("data/FB15k/gold.txt");
        }
        if (target.equals("FB15-237")) {
            trainingSet = new TripleSet("data/FB15-237/train.txt");
            validationSet = new TripleSet("data/FB15-237/valid.txt");
            testSet = new TripleSet("data/FB15-237/test.txt");
            gold = new GoldStandard("data/FB15-237/gold.txt");
        }
        if (target.equals("WN18RR")) {
            trainingSet = new TripleSet("data/WN18RR/train.txt");
            validationSet = new TripleSet("data/WN18RR/valid.txt");
            testSet = new TripleSet("data/WN18RR/test.txt");
        }
        if (target.equals("YAGO")) {
            trainingSet = new TripleSet("data/YAGO03-10/train.txt");
            validationSet = new TripleSet("data/YAGO03-10/valid.txt");
            testSet = new TripleSet("data/YAGO03-10/test.txt");
            gold = null;
        }
        if (target.equals("NELL995")) {
            trainingSet = new TripleSet("data/NELL995/train.txt");
            validationSet = new TripleSet("data/NELL995/valid.txt");
            testSet = new TripleSet("data/NELL995/test.txt");
            gold = null;
        }
        if (target.equals("DB500")) {
            trainingSet = new TripleSet("data/DB500/train.txt");
            validationSet = new TripleSet("data/DB500/valid.txt");
            testSet = new TripleSet("data/DB500/test.txt");
            gold = null;
        }
        if (target.equals("OPENBIO")) {
            trainingSet = new TripleSet("data/OpenBio/train_sample.csv");
            validationSet = new TripleSet("data/OpenBio/val_sample.csv");
            testSet = new TripleSet("data/OpenBio/test_sample.csv");
            gold = null;
        }
        if (target.equals("ASS")) {
            trainingSet = new TripleSet("experiments/SemAssocs/data/empty.txt");
            validationSet = new TripleSet("experiments/SemAssocs/data/empty.txt");
            testSet = new TripleSet("experiments/SemAssocs/data/assoc_test.nt");
            gold = null;
        }
        if (target.equals("MOB")) {
            trainingSet = new TripleSet("data/mob/train.txt");
            validationSet = new TripleSet("data/mob/valid.txt");
            testSet = new TripleSet("data/mob/test.txt");
            gold = null;
        }
        if (target.equals("WD")) {
            trainingSet = new TripleSet("data/WIKIDATA/empty.txt");
            validationSet = new TripleSet("data/WIKIDATA/empty.txt");
            testSet = new TripleSet("data/WIKIDATA/test.txt");
            gold = null;
        }
        if (target.equals("OLPBENCH")) {
            trainingSet = new TripleSet("data/OLPBENCH/empty.txt");
            validationSet = new TripleSet("data/OLPBENCH/empty.txt");
            testSet = new TripleSet("data/OLPBENCH/test_data.txt");
            am = new AlternativeMentions("data/OLPBENCH/test_data.txt");
            gold = null;
        }
        if (target.equals("OLPBENCH2")) {
            trainingSet = new TripleSet("data/OLPBENCH/empty.txt");
            validationSet = new TripleSet("data/OLPBENCH/empty.txt");
            testSet = new TripleSet("data/OLPBENCH/validation_data_linked_mention.txt");
            gold = null;
        }
        ResultSet[] results = null;
        boolean html = false;
        if (target.equals("ASS")) {
            results = new ResultSet[]{new ResultSet("RuleN", "experiments/SemAssocs/predictions/p12-s200.txt", true, 100), new ResultSet("RuleN", "experiments/SemAssocs/predictions/p12-s200-mul.txt", true, 100), new ResultSet("RuleN", "experiments/SemAssocs/predictions/p123-s200.txt", true, 100), new ResultSet("RuleN", "experiments/SemAssocs/predictions/p123-s500.txt", true, 100)};
        }
        if (target.equals("WD")) {
            results = new ResultSet[]{new ResultSet("500      ", "exp/february/final/rg/wikidata-rt-c2a1g1-p2s3-predictionsZ-AVG-500", true, 10), new ResultSet("1000     ", "exp/february/final/rg/wikidata-rt-c2a1g1-p2s3-predictionsZ-AVG-1000", true, 10), new ResultSet("5000     ", "exp/february/final/rg/wikidata-rt-c2a1g1-p2s3-predictionsZ-AVG-5000", true, 10), new ResultSet("10000    ", "exp/february/final/rg/wikidata-rt-c2a1g1-p2s3-predictionsZ-AVG-10000", true, 10)};
        }
        if (target.equals("DIANA")) {
            results = new ResultSet[]{new ResultSet("500      ", "exp/diana/predictions-c5-a2-100", true, 10), new ResultSet("500      ", "exp/diana/horsemen-predictions", true, 10)};
        }
        if (target.equals("MOB")) {
            results = new ResultSet[]{new ResultSet("RuleN", "exp/summer/mob/mob-rules-pred-100", true, 100)};
        }
        if (target.equals("WN18")) {
            ResultSet[] resultSetArray = new ResultSet[16];
            resultSetArray[0] = new ResultSet("all", "exp/september/wn18/wn18-def-rules-1000", true, 10);
            resultSetArray[2] = new ResultSet("wout ac1L1", "exp/september/wn18/wn18-def-rules-1000-without-ac1L1", true, 10);
            resultSetArray[3] = new ResultSet("wout ac2L1", "exp/september/wn18/wn18-def-rules-1000-without-ac2L1", true, 10);
            resultSetArray[4] = new ResultSet("wout cL1", "exp/september/wn18/wn18-def-rules-1000-without-cL1", true, 10);
            resultSetArray[5] = new ResultSet("wout cL2", "exp/september/wn18/wn18-def-rules-1000-without-cL2", true, 10);
            resultSetArray[6] = new ResultSet("wout cL3", "exp/september/wn18/wn18-def-rules-1000-without-cL3", true, 10);
            resultSetArray[7] = new ResultSet("wout ac1L1X", "exp/september/wn18/wn18-def-rules-1000-without-ac1L1X", true, 10);
            resultSetArray[9] = new ResultSet("only ac1L1", "exp/september/wn18/wn18-def-rules-1000-only-ac1L1", true, 10);
            resultSetArray[10] = new ResultSet("only ac2L1", "exp/september/wn18/wn18-def-rules-1000-only-ac2L1", true, 10);
            resultSetArray[11] = new ResultSet("only cL1", "exp/september/wn18/wn18-def-rules-1000-only-cL1", true, 10);
            resultSetArray[12] = new ResultSet("only cL2", "exp/september/wn18/wn18-def-rules-1000-only-cL2", true, 10);
            resultSetArray[13] = new ResultSet("only cL3", "exp/september/wn18/wn18-def-rules-1000-only-cL3", true, 10);
            resultSetArray[14] = new ResultSet("only ac1L1X", "exp/september/wn18/wn18-def-rules-1000-only-ac1L1X", true, 10);
            results = resultSetArray;
        }
        if (target.equals("CODEX-S")) {
            results = new ResultSet[]{new ResultSet("anyburl      ", "exp/understanding/codex-s/anyburl-c3-3600-100-test", true, 100), new ResultSet("AB-complex-MM", "exp/understanding/codex-s/anyburl-c3-3600-100-test-complex-MM", true, 100), new ResultSet("AB-conve-MM  ", "exp/understanding/codex-s/anyburl-c3-3600-100-test-conve-MM", true, 100), new ResultSet("AB-hitter-MM ", "exp/understanding/codex-s/anyburl-c3-3600-100-test-hitter-MM", true, 100), new ResultSet("AB-rescal-MM ", "exp/understanding/codex-s/anyburl-c3-3600-100-test-rescal-MM", true, 100), new ResultSet("AB-transe-MM ", "exp/understanding/codex-s/anyburl-c3-3600-100-test-transe-MM", true, 100), new ResultSet("AB-tucker-MM ", "exp/understanding/codex-s/anyburl-c3-3600-100-test-tucker-MM", true, 100)};
        }
        if (target.equals("CODEX-M")) {
            results = new ResultSet[]{new ResultSet("anyburl       ", "exp/understanding/codex-m/anyburl-c3-3600-100-test", true, 100), new ResultSet("complex-RF ", "exp/understanding/codex-m/complex-100-test-RF", true, 100, true), new ResultSet("conve-RF   ", "exp/understanding/codex-m/conve-100-test-RF", true, 100, true), new ResultSet("hitter-RF  ", "exp/understanding/codex-m/hitter-100-test-RF", true, 100, true), new ResultSet("rescal-RF  ", "exp/understanding/codex-m/rescal-100-test-RF", true, 100, true), new ResultSet("transe-RF  ", "exp/understanding/codex-m/transe-100-test-RF", true, 100, true), new ResultSet("tucker-RF  ", "exp/understanding/codex-m/tucker-100-test-RF", true, 100, true)};
        }
        if (target.equals("CODEX-L")) {
            ResultSet[] resultSetArray = new ResultSet[7];
            resultSetArray[0] = new ResultSet("AB-complex-MM    ", "exp/understanding/codex-l/anyburl-c3-3600-100-test-complex-MM", true, 100);
            resultSetArray[1] = new ResultSet("AB-complex-FF    ", "exp/understanding/codex-l/anyburl-c3-3600-100-test-complex", true, 100, true);
            resultSetArray[2] = new ResultSet("AB-conve-MM      ", "exp/understanding/codex-l/anyburl-c3-3600-100-test-conve-MM", true, 100);
            resultSetArray[3] = new ResultSet("AB-conve-FF      ", "exp/understanding/codex-l/anyburl-c3-3600-100-test-conve", true, 100, true);
            resultSetArray[4] = new ResultSet("AB-hitter-MM     ", "exp/understanding/codex-l/anyburl-c3-3600-100-test-hitter-MM", true, 100);
            resultSetArray[5] = new ResultSet("AB-hitter-FF     ", "exp/understanding/codex-l/anyburl-c3-3600-100-test-hitter", true, 100, true);
            results = resultSetArray;
        }
        if (target.equals("WN18RR")) {
            ResultSet[] resultSetArray = new ResultSet[16];
            resultSetArray[0] = new ResultSet("anyburl  all     ", "exp/understanding/wn18rr/anyburl-c5-3600-100-test", true, 100);
            resultSetArray[1] = new ResultSet("anyburl  2    ", "exp/understanding/wn18rr/anyburl-c2-3600-100-test", true, 100);
            resultSetArray[2] = new ResultSet("anyburl  1    ", "exp/understanding/wn18rr/anyburl-c1-3600-100-test", true, 100);
            resultSetArray[3] = new ResultSet("complex-filtered  ", "exp/understanding/wn18rr/anyburl-c5-3600-100-test-complex", true, 100, true);
            resultSetArray[4] = new ResultSet("conve-filtered    ", "exp/understanding/wn18rr/anyburl-c5-3600-100-test-conve", true, 100, true);
            resultSetArray[5] = new ResultSet("distmult-filtered ", "exp/understanding/wn18rr/anyburl-c5-3600-100-test-distmult", true, 100, true);
            resultSetArray[6] = new ResultSet("hitter-filtered   ", "exp/understanding/wn18rr/anyburl-c5-3600-100-test-hitter", true, 100, true);
            resultSetArray[7] = new ResultSet("rescal-filtered   ", "exp/understanding/wn18rr/anyburl-c5-3600-100-test-rescal", true, 100, true);
            resultSetArray[8] = new ResultSet("transe-filtered   ", "exp/understanding/wn18rr/anyburl-c5-3600-100-test-transe", true, 100, true);
            resultSetArray[10] = new ResultSet("complex-RF ", "exp/understanding/wn18rr/complex-100-test-RF", true, 100, true);
            resultSetArray[11] = new ResultSet("conve-RF   ", "exp/understanding/wn18rr/conve-100-test-RF", true, 100, true);
            resultSetArray[12] = new ResultSet("distmult-RF", "exp/understanding/wn18rr/distmult-100-test-RF", true, 100, true);
            resultSetArray[13] = new ResultSet("hitter-RF  ", "exp/understanding/wn18rr/hitter-100-test-RF", true, 100, true);
            resultSetArray[14] = new ResultSet("rescal-RF  ", "exp/understanding/wn18rr/rescal-100-test-RF", true, 100, true);
            resultSetArray[15] = new ResultSet("transe-RF  ", "exp/understanding/wn18rr/transe-100-test-RF", true, 100, true);
            results = resultSetArray;
        }
        if (target.equals("NUMBERS")) {
            results = new ResultSet[]{new ResultSet("UC identified           ", "../KBCTestdataGenerator/experiments/anyburl/numbers-d3-08-p08-p04-p00-uc-predictions", true, 10), new ResultSet("UC ignored (no overfit) ", "../KBCTestdataGenerator/experiments/anyburl/numbers-d3-08-p08-p04-p00-ucX-predictions", true, 10)};
        }
        if (target.equals("YAGO")) {
            ResultSet[] resultSetArray = new ResultSet[9];
            resultSetArray[0] = new ResultSet("1000 all        ", "exp/zero/yago/yago-predictions-1000-all", true, 20);
            resultSetArray[1] = new ResultSet("1000 all-wo-ac0 ", "exp/zero/yago/yago-predictions-1000-all-wo-ac0", true, 20);
            resultSetArray[2] = new ResultSet("1000 all-wo-ac02", "exp/zero/yago/yago-predictions-1000-all-wo-ac02", true, 20);
            resultSetArray[3] = new ResultSet("1000 all-x      ", "exp/zero/yago/yago-predictions-1000-all-x", true, 20);
            resultSetArray[5] = new ResultSet("1000 ac0        ", "exp/zero/yago/yago-predictions-1000-ac0", true, 20);
            resultSetArray[6] = new ResultSet("1000 ac2        ", "exp/zero/yago/yago-predictions-1000-ac2", true, 20);
            resultSetArray[7] = new ResultSet("1000 ac1        ", "exp/zero/yago/yago-predictions-1000-ac1", true, 20);
            resultSetArray[8] = new ResultSet("1000 c          ", "exp/zero/yago/yago-predictions-1000-c", true, 20);
            results = resultSetArray;
        }
        if (target.equals("NELL995")) {
            ResultSet[] resultSetArray = new ResultSet[5];
            resultSetArray[0] = new ResultSet("200 edisOn1   ", "exp/february/temp/nell-predictions-311-edisOn1-200", true, 10);
            resultSetArray[1] = new ResultSet("200 edisOn2   ", "exp/february/temp/nell-predictions-311-edisOn2-200", true, 10);
            resultSetArray[3] = new ResultSet("200 edisOff1  ", "exp/february/temp/nell-predictions-311-edisOff1-200", true, 10);
            resultSetArray[4] = new ResultSet("200 edisOff2  ", "exp/february/temp/nell-predictions-311-edisOff2-200", true, 10);
            results = resultSetArray;
        }
        if (target.equals("DB500")) {
            results = new ResultSet[]{new ResultSet("100     ", "exp/january/reinforced/db500-predictions-100", true, 10)};
        }
        if (target.equals("FB15-237")) {
            results = new ResultSet[]{new ResultSet("AnyBURL       ", "exp/understanding/fb237/anyburl-c3-3600-100-test", true, 100), new ResultSet("complex-RF ", "exp/understanding/fb237/complex-100-test-RF", true, 100, true), new ResultSet("conve-RF   ", "exp/understanding/fb237/conve-100-test-RF", true, 100, true), new ResultSet("distmult-RF", "exp/understanding/fb237/distmult-100-test-RF", true, 100, true), new ResultSet("hitter-RF  ", "exp/understanding/fb237/hitter-100-test-RF", true, 100, true), new ResultSet("rescal-RF  ", "exp/understanding/fb237/rescal-100-test-RF", true, 100, true), new ResultSet("transe-RF  ", "exp/understanding/fb237/transe-100-test-RF", true, 100, true)};
        }
        if (target.equals("FB15")) {
            results = new ResultSet[]{new ResultSet("1000 all        ", "exp/zero/fb15/fb15-predictions-1000-all", true, 20), new ResultSet("1000 wo-ac0     ", "exp/zero/fb15/fb15-predictions-1000-wo-ac0", true, 20), new ResultSet("1000 wo-ac02    ", "exp/zero/fb15/fb15-predictions-1000-wo-ac02", true, 20), new ResultSet("1000 all-x      ", "exp/zero/fb15/fb15-predictions-1000-all-x", true, 20)};
        }
        if (target.equals("OPENBIO")) {
            results = new ResultSet[]{new ResultSet("all", "exp/openbio/pred-C1-100", true, 10)};
        }
        if (target.equals("OLPBENCH")) {
            ResultSet[] resultSetArray = new ResultSet[9];
            resultSetArray[0] = new ResultSet("  1000", "exp/july/olpbench/predictions-thorough-1000", true, 20);
            resultSetArray[1] = new ResultSet("  5000", "exp/july/olpbench/predictions-thorough-5000", true, 20);
            resultSetArray[2] = new ResultSet(" 10000", "exp/july/olpbench/predictions-thorough-10000", true, 20);
            resultSetArray[4] = new ResultSet("  1000", "exp/july/olpbench/predictions-c5-thorough-1000", true, 20);
            resultSetArray[5] = new ResultSet("  5000", "exp/july/olpbench/predictions-c5-thorough-5000", true, 20);
            resultSetArray[6] = new ResultSet(" 10000", "exp/july/olpbench/predictions-c5-thorough-10000", true, 10);
            resultSetArray[7] = new ResultSet(" 20000", "exp/july/olpbench/predictions-c5-thorough-20000", true, 10);
            resultSetArray[8] = new ResultSet(" 40000", "exp/july/olpbench/predictions-c5-thorough-40000", true, 10);
            results = resultSetArray;
        }
        if (target.equals("OLPBENCH2")) {
            results = new ResultSet[]{new ResultSet(" 10000", "exp/july/olpbench/predictions-vdlm-thorough-10000", true, 10)};
        }
        HitsAtK hitsAtK = new HitsAtK();
        hitsAtK.addFilterTripleSet(trainingSet);
        hitsAtK.addFilterTripleSet(validationSet);
        hitsAtK.addFilterTripleSet(testSet);
        if (am != null) {
            hitsAtK.addAlternativeMentions(am);
        }
        GoldStandard goldSymmetry = null;
        GoldStandard goldEquivalence = null;
        GoldStandard goldSubsumption = null;
        GoldStandard goldPath = null;
        GoldStandard goldUncovered = null;
        if (gold != null) {
            goldSymmetry = gold.getSubset("Symmetry");
            goldEquivalence = gold.getSubset("Equivalence");
            goldSubsumption = gold.getSubset("Subsumption");
            goldPath = gold.getSubset("Path");
            goldUncovered = gold.getSubset("Not covered");
        }
        ResultSet[] resultSetArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            ResultSet rs = resultSetArray[n2];
            if (rs == null) {
                System.out.println("------------------");
            } else {
                if (gold == null) {
                    ComparativeEvaluation.computeScores(rs, testSet, hitsAtK);
                    System.out.print(String.valueOf(rs.getName()) + "\t" + hitsAtK.getHitsAtK(0) + "\t" + hitsAtK.getHitsAtK(9) + "\t" + hitsAtK.getApproxMRR());
                    hitsAtK.reset();
                } else if (html) {
                    ComparativeEvaluation.computeScores(rs, testSet, hitsAtK);
                    System.out.print("<tr><td><span class=\"important\">" + rs.getName() + "</span></td><td>" + hitsAtK.getHitsAtK(0) + "</td> <td>" + hitsAtK.getHitsAtK(9) + "</td> <td></td> <td></td> <td></td></tr>");
                    hitsAtK.reset();
                } else {
                    ComparativeEvaluation.computeScores(rs, gold, hitsAtK);
                    System.out.print(String.valueOf(rs.getName()) + "\t" + hitsAtK.getHitsAtK(0) + "\t" + hitsAtK.getHitsAtK(9) + "\t" + hitsAtK.getApproxMRR());
                    hitsAtK.reset();
                }
                System.out.println();
            }
            ++n2;
        }
    }

    private static void computeScores(ResultSet rs, GoldStandard gold, HitsAtK hitsAtK) {
        for (String triple : gold.triples) {
            ArrayList<String> cand;
            String relation;
            if (RELATION_FILTER.size() > 0 && !RELATION_FILTER.contains(relation = triple.split(" ")[1])) continue;
            String[] tt = triple.split(" ");
            Triple t = new Triple(tt[0], tt[1], tt[2]);
            if (gold.getCategory(triple, true) != null) {
                cand = rs.getHeadCandidates(triple);
                if (ALL_HEAD_TAIL == 0 || ALL_HEAD_TAIL == 1) {
                    hitsAtK.evaluateHead(cand, t);
                }
            }
            if (gold.getCategory(triple, false) == null) continue;
            cand = rs.getTailCandidates(triple);
            if (ALL_HEAD_TAIL != 0 && ALL_HEAD_TAIL != 2) continue;
            hitsAtK.evaluateTail(cand, t);
        }
    }

    private static void computeScores(ResultSet rs, TripleSet gold, HitsAtK hitsAtK) {
        for (Triple t : gold.getTriples()) {
            if (RELATION_FILTER.size() > 0 && !RELATION_FILTER.contains(t.getRelation())) continue;
            if (!target.equals("ASS")) {
                String c1;
                ArrayList<String> cand1 = rs.getHeadCandidates(t.toString());
                String string = c1 = cand1.size() > 0 ? cand1.get(0) : "-";
                if (ALL_HEAD_TAIL == 0 || ALL_HEAD_TAIL == 1) {
                    hitsAtK.evaluateHead(cand1, t);
                }
            }
            ArrayList<String> cand2 = rs.getTailCandidates(t.toString());
            if (ALL_HEAD_TAIL != 0 && ALL_HEAD_TAIL != 2) continue;
            hitsAtK.evaluateTail(cand2, t);
        }
    }

    private static void printAndMarkUnfoundTriples(ResultSet rs, GoldStandard gold, HitsAtK hitsAtK) {
        for (String triple : gold.triples) {
            int foundAt;
            String c;
            ArrayList<String> cand;
            String[] tt = triple.split(" ");
            Triple t = new Triple(tt[0], tt[1], tt[2]);
            if (gold.getCategory(triple, true) != null) {
                cand = rs.getHeadCandidates(triple);
                c = cand.size() > 0 ? cand.get(0) : "-";
                foundAt = hitsAtK.evaluateHead(cand, t);
                if (foundAt < 0) {
                    System.out.println(String.valueOf(t.getHead()) + " headX" + t.getRelation() + " " + t.getTail());
                }
            }
            if (gold.getCategory(triple, false) == null) continue;
            cand = rs.getTailCandidates(triple);
            c = cand.size() > 0 ? cand.get(0) : "-";
            foundAt = hitsAtK.evaluateTail(cand, t);
            if (foundAt >= 0) continue;
            System.out.println(String.valueOf(t.getHead()) + " tailX" + t.getRelation() + " " + t.getTail());
        }
    }

    private static void compareResultSets(ResultSet rs1, ResultSet rs2, GoldStandard gold, HitsAtK hitsAtK) {
        for (String triple : gold.triples) {
            boolean foundBy2;
            boolean foundBy1;
            ArrayList<String> cand2;
            ArrayList<String> cand1;
            String[] tt = triple.split(" ");
            Triple t = new Triple(tt[0], tt[1], tt[2]);
            if (gold.getCategory(triple, true) != null) {
                cand1 = rs1.getHeadCandidates(triple);
                cand2 = rs2.getHeadCandidates(triple);
                foundBy1 = false;
                for (String c1 : cand1) {
                    if (!t.getHead().equals(c1)) continue;
                    foundBy1 = true;
                }
                foundBy2 = false;
                for (String string : cand2) {
                    if (!t.getHead().equals(string)) continue;
                    foundBy2 = true;
                }
                if (foundBy1 != foundBy2) {
                    System.out.println("H " + rs1.getName() + "=" + foundBy1 + " " + rs2.getName() + "=" + foundBy2 + " " + triple);
                }
            }
            if (gold.getCategory(triple, false) == null) continue;
            cand1 = rs1.getTailCandidates(triple);
            cand2 = rs2.getTailCandidates(triple);
            foundBy1 = false;
            for (String c1 : cand1) {
                if (!t.getTail().equals(c1)) continue;
                foundBy1 = true;
            }
            foundBy2 = false;
            for (String string : cand2) {
                if (!t.getTail().equals(string)) continue;
                foundBy2 = true;
            }
            if (foundBy1 == foundBy2) continue;
            System.out.println("T " + rs1.getName() + "=" + foundBy1 + " " + rs2.getName() + "=" + foundBy2 + " " + triple);
        }
    }
}

