/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.eval;

import de.unima.ki.anyburl.Settings;
import de.unima.ki.anyburl.data.Triple;
import de.unima.ki.anyburl.data.TripleSet;
import de.unima.ki.anyburl.eval.HitsAtK;
import de.unima.ki.anyburl.eval.ResultSet;
import de.unima.ki.anyburl.io.IOHelper;
import de.unima.ki.anyburl.structure.Rule;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;

public class EvalByRelation {
    private static String CONFIG_FILE = "config-eval.properties";
    public static int TOP_K = 100;
    public static String PATH_TRAINING = "";
    public static String PATH_TEST = "";
    public static String PATH_VALID = "";
    public static String PATH_PREDICTIONS = "";
    public static boolean EVAL_HEAD_ONLY = false;
    public static boolean EVAL_TAIL_ONLY = false;

    public static void main(String[] args) throws IOException {
        block17: {
            if (args.length == 1) {
                CONFIG_FILE = args[0];
                System.out.println("reading params from file " + CONFIG_FILE);
            }
            Rule.applicationMode();
            Settings.REWRITE_REFLEXIV = false;
            Properties prop = new Properties();
            FileInputStream input = null;
            try {
                try {
                    input = new FileInputStream(CONFIG_FILE);
                    prop.load(input);
                    Settings.SAFE_PREFIX_MODE = IOHelper.getProperty(prop, "SAFE_PREFIX_MODE", Settings.SAFE_PREFIX_MODE);
                    PATH_TRAINING = IOHelper.getProperty(prop, "PATH_TRAINING", PATH_TRAINING);
                    PATH_TEST = IOHelper.getProperty(prop, "PATH_TEST", PATH_TEST);
                    PATH_VALID = IOHelper.getProperty(prop, "PATH_VALID", PATH_VALID);
                    PATH_PREDICTIONS = IOHelper.getProperty(prop, "PATH_PREDICTIONS", PATH_PREDICTIONS);
                    TOP_K = IOHelper.getProperty(prop, "TOP_K", TOP_K);
                }
                catch (IOException ex) {
                    System.err.println("Could not read relevant parameters from the config file " + CONFIG_FILE);
                    ex.printStackTrace();
                    System.exit(1);
                    if (input != null) {
                        try {
                            ((InputStream)input).close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            System.exit(1);
                        }
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
                throw throwable;
            }
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
        }
        TripleSet trainingSet = new TripleSet(PATH_TRAINING);
        TripleSet validationSet = new TripleSet(PATH_VALID);
        TripleSet testSet = new TripleSet(PATH_TEST);
        HitsAtK hitsAtK = new HitsAtK();
        hitsAtK.addFilterTripleSet(trainingSet);
        hitsAtK.addFilterTripleSet(validationSet);
        hitsAtK.addFilterTripleSet(testSet);
        ResultSet rs = new ResultSet(PATH_PREDICTIONS, true, TOP_K);
        ArrayList<String> relations = new ArrayList<String>();
        for (String relation : testSet.getRelations()) {
            relations.add(relation);
        }
        Collections.sort(relations);
        for (String relation : relations) {
            TripleSet tsr = EvalByRelation.getTripleSubSetByRelation(testSet, relation);
            EvalByRelation.computeScores(rs, tsr, hitsAtK);
            System.out.println(String.valueOf(relation) + "\t" + tsr.size() + "\t" + hitsAtK.getMRR() + "\t" + hitsAtK.getMRRHeads() + "\t" + hitsAtK.getMRRTails() + "\t" + hitsAtK.getHitsAtK(0));
            hitsAtK.reset();
        }
        EvalByRelation.computeScores(rs, testSet, hitsAtK);
        System.out.println("all-relations\t" + testSet.size() + "\t" + hitsAtK.getMRR() + "\t" + hitsAtK.getMRRHeads() + "\t" + hitsAtK.getMRRTails());
        hitsAtK.reset();
    }

    private static TripleSet getTripleSubSetByRelation(TripleSet ts, String relation) {
        TripleSet tsr = new TripleSet();
        for (Triple t : ts.getTriplesByRelation(relation)) {
            tsr.addTriple(t);
        }
        return tsr;
    }

    private static void computeScores(ResultSet rs, TripleSet gold, HitsAtK hitsAtK) {
        for (Triple t : gold.getTriples()) {
            ArrayList<String> cand1 = rs.getHeadCandidates(t.toString());
            hitsAtK.evaluateHead(cand1, t);
            ArrayList<String> cand2 = rs.getTailCandidates(t.toString());
            hitsAtK.evaluateTail(cand2, t);
        }
    }
}

