/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.eval;

import de.unima.ki.anyburl.data.Triple;
import de.unima.ki.anyburl.data.TripleSet;
import de.unima.ki.anyburl.eval.AlternativeMentions;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;

public class HitsAtK {
    private ArrayList<TripleSet> filterSets = new ArrayList();
    private static final int ATKMAX = 100;
    private int[] hitsADnTail = new int[100];
    private int[] hitsADnTailFiltered = new int[100];
    private int counterTail = 0;
    private int counterTailCovered = 0;
    private ArrayList<Integer> headRanks = new ArrayList();
    private ArrayList<Integer> tailRanks = new ArrayList();
    private int[] hitsADnHead = new int[100];
    private int[] hitsADnHeadFiltered = new int[100];
    private int counterHead = 0;
    private int counterHeadCovered = 0;
    private static NumberFormat nf = NumberFormat.getInstance(Locale.US);
    private static DecimalFormat df = (DecimalFormat)nf;
    private AlternativeMentions am = null;

    public HitsAtK() throws IOException {
        df.applyPattern("0.0000");
    }

    public void reset() {
        this.hitsADnHead = new int[100];
        this.hitsADnHeadFiltered = new int[100];
        this.counterHead = 0;
        this.counterHeadCovered = 0;
        this.hitsADnTail = new int[100];
        this.hitsADnTailFiltered = new int[100];
        this.counterTail = 0;
        this.counterTailCovered = 0;
        this.headRanks = new ArrayList();
        this.tailRanks = new ArrayList();
    }

    public String getApproxMRR() {
        double mrr = 0.0;
        double hk = 0.0;
        double hk_prev = 0.0;
        double hk_diff = 0.0;
        int k = 0;
        while (k < 100) {
            hk = (double)(this.hitsADnHeadFiltered[k] + this.hitsADnTailFiltered[k]) / (double)(this.counterHead + this.counterTail);
            hk_diff = hk - hk_prev;
            mrr += hk_diff * (1.0 / (double)(k + 1));
            hk_prev = hk;
            ++k;
        }
        double mrr_low = mrr;
        return HitsAtK.f(mrr_low);
    }

    public double getMRR() {
        double mrr = 0.0;
        double hk = 0.0;
        double hk_prev = 0.0;
        double hk_diff = 0.0;
        int k = 0;
        while (k < 100) {
            hk = (double)(this.hitsADnHeadFiltered[k] + this.hitsADnTailFiltered[k]) / (double)(this.counterHead + this.counterTail);
            hk_diff = hk - hk_prev;
            mrr += hk_diff * (1.0 / (double)(k + 1));
            hk_prev = hk;
            ++k;
        }
        return mrr;
    }

    public double getMRRHeads() {
        double mrr = 0.0;
        double hk = 0.0;
        double hk_prev = 0.0;
        double hk_diff = 0.0;
        int k = 0;
        while (k < 100) {
            hk = (double)this.hitsADnHeadFiltered[k] / (double)this.counterHead;
            hk_diff = hk - hk_prev;
            mrr += hk_diff * (1.0 / (double)(k + 1));
            hk_prev = hk;
            ++k;
        }
        return mrr;
    }

    public double getMRRTails() {
        double mrr = 0.0;
        double hk = 0.0;
        double hk_prev = 0.0;
        double hk_diff = 0.0;
        int k = 0;
        while (k < 100) {
            hk = (double)this.hitsADnTailFiltered[k] / (double)this.counterTail;
            hk_diff = hk - hk_prev;
            mrr += hk_diff * (1.0 / (double)(k + 1));
            hk_prev = hk;
            ++k;
        }
        return mrr;
    }

    public String getHitsAtK(int k) {
        String hitsAtK = HitsAtK.f((double)(this.hitsADnHeadFiltered[k] + this.hitsADnTailFiltered[k]) / (double)(this.counterHead + this.counterTail));
        return hitsAtK;
    }

    public String getHitsAtKCalculation(int k) {
        String hitsAtK = this.hitsADnHeadFiltered[k] + " + " + this.hitsADnTailFiltered[k] + " / " + this.counterHead + " + " + this.counterTail;
        return hitsAtK;
    }

    public double getHitsAtKDouble(int k) {
        return (double)(this.hitsADnHeadFiltered[k] + this.hitsADnTailFiltered[k]) / (double)(this.counterHead + this.counterTail);
    }

    public void evaluateHead() {
        ++this.counterHead;
    }

    public void evaluateTail() {
        ++this.counterTail;
    }

    public int evaluateHead(ArrayList<String> candidates, Triple triple) {
        int foundAt = -1;
        ++this.counterHead;
        if (candidates.size() > 0) {
            ++this.counterHeadCovered;
        }
        int filterCount = 0;
        int rank = 0;
        while (rank < candidates.size() && rank < 100) {
            String candidate = candidates.get(rank);
            if (candidate.equals(triple.getHead()) || this.am != null && this.am.sameAs(triple.getHead(), candidate)) {
                int index = rank;
                while (index - filterCount < 100) {
                    if (index < 100) {
                        int n = index;
                        this.hitsADnHead[n] = this.hitsADnHead[n] + 1;
                    }
                    int n = index - filterCount;
                    this.hitsADnHeadFiltered[n] = this.hitsADnHeadFiltered[n] + 1;
                    ++index;
                }
                foundAt = rank + 1;
                break;
            }
            for (TripleSet filterSet : this.filterSets) {
                if (!filterSet.isTrue(candidate, triple.getRelation(), triple.getTail())) continue;
                ++filterCount;
                break;
            }
            ++rank;
        }
        int counter = 0;
        boolean ranked = false;
        for (String candidate : candidates) {
            ++counter;
            if (!candidate.equals(triple.getHead())) continue;
            this.headRanks.add(counter);
            ranked = true;
            break;
        }
        if (!ranked) {
            this.headRanks.add(-1);
        }
        return foundAt;
    }

    public int evaluateTail(ArrayList<String> candidates, Triple triple) {
        int foundAt = -1;
        ++this.counterTail;
        if (candidates.size() > 0) {
            ++this.counterTailCovered;
        }
        int filterCount = 0;
        int rank = 0;
        while (rank < candidates.size() && rank < 100) {
            String candidate = candidates.get(rank);
            if (candidate.equals(triple.getTail()) || this.am != null && this.am.sameAs(triple.getTail(), candidate)) {
                int index = rank;
                while (index - filterCount < 100) {
                    if (index < 100) {
                        int n = index;
                        this.hitsADnTail[n] = this.hitsADnTail[n] + 1;
                    }
                    int n = index - filterCount;
                    this.hitsADnTailFiltered[n] = this.hitsADnTailFiltered[n] + 1;
                    ++index;
                }
                foundAt = rank + 1;
                break;
            }
            for (TripleSet filterSet : this.filterSets) {
                if (!filterSet.isTrue(triple.getHead(), triple.getRelation(), candidate)) continue;
                ++filterCount;
                break;
            }
            ++rank;
        }
        int counter = 0;
        boolean ranked = false;
        for (String candidate : candidates) {
            ++counter;
            if (!candidate.equals(triple.getTail())) continue;
            this.tailRanks.add(counter);
            ranked = true;
            break;
        }
        if (!ranked) {
            this.tailRanks.add(-1);
        }
        return foundAt;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("evaluation result\n");
        sb.append("hits@k\traw\t\t\tfilter\n");
        sb.append("hits@k\ttail\thead\ttotal\ttail\thead\ttotal\n");
        int i = 0;
        while (i < 100) {
            sb.append(i + 1);
            sb.append("\t");
            sb.append(HitsAtK.f((double)this.hitsADnTail[i] / (double)this.counterTail));
            sb.append("\t");
            sb.append(HitsAtK.f((double)this.hitsADnHead[i] / (double)this.counterHead));
            sb.append("\t");
            sb.append(HitsAtK.f((double)(this.hitsADnHead[i] + this.hitsADnTail[i]) / (double)(this.counterHead + this.counterTail)));
            sb.append("\t");
            sb.append(HitsAtK.f((double)this.hitsADnTailFiltered[i] / (double)this.counterTail));
            sb.append("\t");
            sb.append(HitsAtK.f((double)this.hitsADnHeadFiltered[i] / (double)this.counterHead));
            sb.append("\t");
            sb.append(HitsAtK.f((double)(this.hitsADnHeadFiltered[i] + this.hitsADnTailFiltered[i]) / (double)(this.counterHead + this.counterTail)));
            sb.append("\n");
            ++i;
        }
        sb.append("counterHead=" + this.counterHead + " counterTail=" + this.counterTail + " hits@10Tail=" + this.hitsADnTail[99] + " hits@10Head=" + this.hitsADnHead[99] + "\n");
        sb.append("counterHead=" + this.counterHead + " counterTail=" + this.counterTail + " hits@10TailFiltered=" + this.hitsADnTailFiltered[99] + " hits@10HeadFiltered=" + this.hitsADnHeadFiltered[99] + "\n");
        sb.append("fraction of head covered by rules  = " + (double)this.counterHeadCovered / (double)this.counterHead + "\n");
        sb.append("fraction of tails covered by rules = " + (double)this.counterTailCovered / (double)this.counterTail + "\n");
        return sb.toString();
    }

    public static String f(double v) {
        return df.format(v);
    }

    public void addFilterTripleSet(TripleSet tripleSet) {
        this.filterSets.add(tripleSet);
    }

    public String getMRR(int numOfInstances) {
        double headMrr = this.getMRR(numOfInstances, this.headRanks);
        double tailMrr = this.getMRR(numOfInstances, this.tailRanks);
        return HitsAtK.f((headMrr + tailMrr) / 2.0);
    }

    private double getMRR(int numOfInstances, ArrayList<Integer> numbers) {
        double mrr = 0.0;
        int i = 0;
        while (i < numbers.size()) {
            mrr = numbers.get(i) > 0 ? (mrr += 1.0 / (double)numbers.get(i).intValue()) : (mrr += 2.0 / (double)numOfInstances);
            ++i;
        }
        return mrr /= (double)numbers.size();
    }

    public void addAlternativeMentions(AlternativeMentions am) {
        this.am = am;
    }
}

