/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.eval;

import de.unima.ki.anyburl.data.Triple;
import de.unima.ki.anyburl.eval.CompletionResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ResultSet
implements Iterable<CompletionResult> {
    public HashMap<String, CompletionResult> results;
    public String name;
    public static boolean applyThreshold = false;
    public static double threshold = 0.0;
    private boolean containsConfidences = false;

    public static void main(String[] args) throws FileNotFoundException {
        LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
        map.put("a", 0.8);
        map.put("b", 0.7);
        map.put("c", 0.9);
        map.put("d", 0.1);
        map.put("e", 2.7);
        map.put("f", 0.88);
        map.put("g", 0.1222);
        ResultSet.orderByValueDescending(map);
        for (Map.Entry<String, Double> e : map.entrySet()) {
            System.out.println(e);
        }
    }

    public ResultSet(ResultSet that, String relation) {
        this.containsConfidences = that.containsConfidences;
        this.results = new HashMap();
        for (String triple : that.results.keySet()) {
            if (!triple.split(" ")[1].equals(relation)) continue;
            this.results.put(triple, that.results.get(triple));
        }
    }

    public ResultSet() {
        this.results = new HashMap();
    }

    public ResultSet(String name, String filePath) {
        this(name, filePath, false, 0);
    }

    public ResultSet(String name, boolean containsConfidences, int k) {
        this(name, name, containsConfidences, k);
    }

    public CompletionResult getCompletionResult(String triple) {
        CompletionResult cr = this.results.get(triple);
        return cr;
    }

    public CompletionResult getCompletionResult(Triple triple) {
        CompletionResult cr = this.results.get(triple.toString());
        return cr;
    }

    public Set<String> getTriples() {
        return this.results.keySet();
    }

    public ResultSet(String name, String filePath, boolean containsConfidences, int k, boolean adjust) {
        this(name, filePath, containsConfidences, k);
        if (adjust) {
            this.adjust();
        }
    }

    public ResultSet(String name, String filePath, boolean containsConfidences, int k) {
        System.out.println("* loading result set at " + filePath);
        this.containsConfidences = containsConfidences;
        this.name = name;
        this.results = new HashMap();
        long counter = 0L;
        long stepsize = 100000L;
        File file = null;
        try {
            String tripleLine;
            file = new File(filePath);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
            while ((tripleLine = bufferedReader.readLine()) != null) {
                if (++counter % stepsize == 0L) {
                    System.out.println("* parsed " + counter + " lines of results file");
                }
                if (tripleLine.length() < 3) continue;
                CompletionResult cr = new CompletionResult(tripleLine);
                String headLine = bufferedReader.readLine();
                String tailLine = bufferedReader.readLine();
                String tempLine = "";
                if (headLine.startsWith("Tails:")) {
                    tempLine = headLine;
                    headLine = tailLine;
                    tailLine = tempLine;
                }
                if (!applyThreshold) {
                    cr.addHeadResults(this.getResultsFromLine(headLine.substring(7)), k);
                    cr.addHeadConfidences(this.getConfidencesFromLine(headLine.substring(7)), k);
                    cr.addTailResults(this.getResultsFromLine(tailLine.substring(7)), k);
                    cr.addTailConfidences(this.getConfidencesFromLine(tailLine.substring(7)), k);
                } else {
                    cr.addHeadResults(this.getThresholdedResultsFromLine(headLine.substring(7)), k);
                    cr.addHeadConfidences(this.getThresholdedConfidencesFromLine(headLine.substring(7)), k);
                    cr.addTailResults(this.getThresholdedResultsFromLine(tailLine.substring(7)), k);
                    cr.addTailConfidences(this.getThresholdedConfidencesFromLine(tailLine.substring(7)), k);
                }
                this.results.put(tripleLine.split("\t")[0], cr);
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            System.err.println("problem related to file " + file + ".");
            e.printStackTrace();
        }
    }

    public void extendWith(ResultSet rs, int k, double factor) {
        for (String t : this.results.keySet()) {
            CompletionResult thisResult = this.results.get(t);
            CompletionResult thatResult = rs.results.get(t);
            thisResult.extendWith(thatResult, k, factor);
        }
    }

    public void printAsTripleSet(String path) throws FileNotFoundException {
        PrintWriter pw = new PrintWriter(path);
        for (String line : this.results.keySet()) {
            String[] token = line.split("\\s+");
            CompletionResult cr = this.results.get(line);
            int i = 0;
            for (String h : cr.getHeads()) {
                pw.println(String.valueOf(h) + " " + token[1] + " " + token[2]);
                ++i;
            }
            i = 0;
            for (String t : cr.getTails()) {
                pw.println(String.valueOf(token[0]) + " " + token[1] + " " + t);
                ++i;
            }
            pw.flush();
        }
        pw.close();
    }

    public void printAsWeightedTripleSet(String path) throws FileNotFoundException {
        PrintWriter pw = new PrintWriter(path);
        for (String line : this.results.keySet()) {
            String[] token = line.split("\\s+");
            CompletionResult cr = this.results.get(line);
            int i = 0;
            for (String h : cr.getHeads()) {
                double dh = cr.getHeadConfidences().get(i);
                pw.println(String.valueOf(h) + "\t" + token[1] + "\t" + token[2] + "\t" + dh);
                ++i;
            }
            i = 0;
            for (String t : cr.getTails()) {
                double dt = cr.getTailConfidences().get(i);
                pw.println(String.valueOf(token[0]) + "\t" + token[1] + "\t" + t + "\t" + dt);
                ++i;
            }
            pw.flush();
        }
        pw.close();
    }

    private String[] getThresholdedResultsFromLine(String rline) {
        if (!this.containsConfidences) {
            return rline.split("\t");
        }
        String t = "";
        String cS = "";
        String[] token = rline.split("\t");
        ArrayList<String> tokenx = new ArrayList<String>();
        int i = 0;
        while (i < token.length / 2) {
            t = token[i * 2];
            cS = token[i * 2 + 1];
            double c = Double.parseDouble(cS);
            if (!(c > threshold)) break;
            tokenx.add(t);
            ++i;
        }
        String[] tokenxx = tokenx.toArray(new String[0]);
        return tokenxx;
    }

    private Double[] getThresholdedConfidencesFromLine(String rline) {
        if (!this.containsConfidences) {
            System.err.println("there are no confidences, you cannot retrieve them (line: " + rline + ")");
            return null;
        }
        String t = "";
        String cS = "";
        String[] token = rline.split("\t");
        ArrayList<Double> tokenx = new ArrayList<Double>();
        int i = 0;
        while (i < token.length / 2) {
            cS = token[i * 2 + 1];
            double c = Double.parseDouble(cS);
            if (!(c > threshold)) break;
            tokenx.add(c);
            ++i;
        }
        Double[] tokenxx = tokenx.toArray(new Double[0]);
        return tokenxx;
    }

    private String[] getResultsFromLine(String rline) {
        if (!this.containsConfidences) {
            return rline.split("\t");
        }
        String[] token = rline.split("\t");
        String[] tokenx = new String[token.length / 2];
        int i = 0;
        while (i < tokenx.length) {
            tokenx[i] = token[i * 2];
            ++i;
        }
        return tokenx;
    }

    private Double[] getConfidencesFromLine(String rline) {
        if (!this.containsConfidences) {
            System.err.println("there are no confidences, you cannot retrieve them (line: " + rline + ")");
            return null;
        }
        String[] token = rline.split("\t");
        Double[] tokenx = new Double[token.length / 2];
        int i = 0;
        while (i < tokenx.length) {
            tokenx[i] = Double.parseDouble(token[i * 2 + 1]);
            ++i;
        }
        return tokenx;
    }

    public ArrayList<String> getHeadCandidates(String triple) {
        try {
            CompletionResult cr = this.results.get(triple);
            if (cr == null && triple.contains("\t")) {
                triple.replaceAll("\t", " ");
            }
            return cr.getHeads();
        }
        catch (RuntimeException e) {
            return new ArrayList<String>();
        }
    }

    public ArrayList<String> getTailCandidates(String triple) {
        try {
            CompletionResult cr = this.results.get(triple);
            if (cr == null) {
                System.err.println("cpould not find required triple (" + triple + ")in results set");
                for (String k : this.results.keySet()) {
                    System.out.println(k);
                }
                System.exit(0);
            }
            return cr.getTails();
        }
        catch (RuntimeException e) {
            return new ArrayList<String>();
        }
    }

    public ArrayList<Double> getHeadConfidences(String triple) {
        try {
            CompletionResult cr = this.results.get(triple);
            return cr.getHeadConfidences();
        }
        catch (RuntimeException e) {
            return new ArrayList<Double>();
        }
    }

    public ArrayList<Double> getTailConfidences(String triple) {
        try {
            CompletionResult cr = this.results.get(triple);
            return cr.getTailConfidences();
        }
        catch (RuntimeException e) {
            return new ArrayList<Double>();
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Iterator<CompletionResult> iterator() {
        return this.results.values().iterator();
    }

    public void write(String filepath) throws FileNotFoundException {
        PrintWriter pw = new PrintWriter(filepath);
        for (CompletionResult cr : this.results.values()) {
            cr.write(pw);
        }
        pw.flush();
        pw.close();
    }

    public void reorder(ResultSet that) {
        for (String tripleAsString : this.results.keySet()) {
            CompletionResult thisCr = this.getCompletionResult(tripleAsString);
            CompletionResult thatCr = that.getCompletionResult(tripleAsString);
            CompletionResult reorderedCr = new CompletionResult(tripleAsString);
            ArrayList<String> reorderedHeads = new ArrayList<String>();
            ArrayList<Double> reorderedHeadConfidences = new ArrayList<Double>();
            this.reorderLists(reorderedHeads, reorderedHeadConfidences, thisCr.getHeads(), thatCr.getHeads());
            reorderedCr.setHeads(reorderedHeads);
            reorderedCr.setHeadConfidences(reorderedHeadConfidences);
            ArrayList<String> reorderedTails = new ArrayList<String>();
            ArrayList<Double> reorderedTailConfidences = new ArrayList<Double>();
            this.reorderLists(reorderedTails, reorderedTailConfidences, thisCr.getTails(), thatCr.getTails());
            reorderedCr.setTails(reorderedTails);
            reorderedCr.setTailConfidences(reorderedTailConfidences);
            this.results.put(tripleAsString, reorderedCr);
        }
    }

    public ResultSet reorderWeighted(ResultSet that, int alpha, double beta) {
        ResultSet rs = new ResultSet();
        for (String tripleAsString : this.results.keySet()) {
            CompletionResult thisCr = this.getCompletionResult(tripleAsString);
            CompletionResult thatCr = that.getCompletionResult(tripleAsString);
            CompletionResult reorderedCr = new CompletionResult(tripleAsString);
            ArrayList<String> reorderedHeads = new ArrayList<String>();
            ArrayList<Double> reorderedHeadConfidences = new ArrayList<Double>();
            this.reorderListsWeighted(reorderedHeads, reorderedHeadConfidences, thisCr.getHeads(), thisCr.getHeadConfidences(), thatCr.getHeads(), alpha, beta);
            reorderedCr.setHeads(reorderedHeads);
            reorderedCr.setHeadConfidences(reorderedHeadConfidences);
            ArrayList<String> reorderedTails = new ArrayList<String>();
            ArrayList<Double> reorderedTailConfidences = new ArrayList<Double>();
            this.reorderListsWeighted(reorderedTails, reorderedTailConfidences, thisCr.getTails(), thisCr.getTailConfidences(), thatCr.getTails(), alpha, beta);
            reorderedCr.setTails(reorderedTails);
            reorderedCr.setTailConfidences(reorderedTailConfidences);
            rs.results.put(tripleAsString, reorderedCr);
        }
        return rs;
    }

    private static void orderByValueDescending(LinkedHashMap<String, Double> m) {
        ArrayList<Map.Entry<String, Double>> entries = new ArrayList<Map.Entry<String, Double>>(m.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<String, Double>>(){

            @Override
            public int compare(Map.Entry<String, Double> lhs, Map.Entry<String, Double> rhs) {
                if (lhs.getValue() - rhs.getValue() > 0.0) {
                    return -1;
                }
                if (lhs.getValue() - rhs.getValue() == 0.0) {
                    return 0;
                }
                return 1;
            }
        });
        m.clear();
        for (Map.Entry entry : entries) {
            m.put((String)entry.getKey(), (Double)entry.getValue());
        }
    }

    private void reorderLists(ArrayList<String> reorderedCandidates, ArrayList<Double> reorderedConfidences, ArrayList<String> thisCandidates, ArrayList<String> thatCandidates) {
        String candidate;
        HashSet<String> reorderedCandidatesHashed = new HashSet<String>();
        int i = 0;
        while (i < thatCandidates.size()) {
            candidate = thatCandidates.get(i);
            if (thisCandidates.contains(candidate)) {
                reorderedCandidates.add(candidate);
                reorderedCandidatesHashed.add(candidate);
            }
            ++i;
        }
        i = 0;
        while (i < thisCandidates.size()) {
            candidate = thisCandidates.get(i);
            if (!reorderedCandidatesHashed.contains(candidate)) {
                reorderedCandidates.add(candidate);
            }
            ++i;
        }
        double stepsize = 0.5 / (double)reorderedCandidates.size();
        int i2 = 0;
        while (i2 < reorderedCandidates.size()) {
            reorderedConfidences.add(1.0 - (double)i2 * stepsize);
            ++i2;
        }
    }

    private void reorderListsWeighted(ArrayList<String> reorderedCandidates, ArrayList<Double> reorderedConfidences, ArrayList<String> thisCandidates, ArrayList<Double> thisConfidences, ArrayList<String> thatCandidates, int alpha, double beta) {
        LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
        int i = 0;
        while (i < thisCandidates.size()) {
            String candidate = thisCandidates.get(i);
            double givenConfidence = thisConfidences.get(i);
            double thatFactor = 0.0;
            int indexInThat = thatCandidates.lastIndexOf(candidate);
            int pos = 0;
            if (indexInThat == -1) {
                thatFactor = (1.0 + (double)alpha) / (double)(thatCandidates.size() + 1 + alpha);
                pos = thatCandidates.size() + 1;
            } else {
                thatFactor = (1.0 + (double)alpha) / (double)(indexInThat + 1 + alpha);
                pos = indexInThat + 1;
            }
            double score = beta * (givenConfidence * thatFactor) + (1.0 - beta) * (1.0 / (double)pos);
            map.put(candidate, score);
            ++i;
        }
        ResultSet.orderByValueDescending(map);
        for (Map.Entry<String, Double> e : map.entrySet()) {
            reorderedCandidates.add(e.getKey());
            reorderedConfidences.add(e.getValue());
        }
    }

    public void adjust() {
        for (String task : this.results.keySet()) {
            CompletionResult cr = this.results.get(task);
            LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
            int i = 0;
            while (i < cr.getHeads().size()) {
                map.put(cr.getHeads().get(i), cr.getHeadConfidences().get(i));
                ++i;
            }
            ResultSet.orderByValueDescending(map);
            ArrayList<String> reorderedCandidates = new ArrayList<String>();
            ArrayList<Double> reorderedConfidences = new ArrayList<Double>();
            for (Map.Entry<String, Double> e : map.entrySet()) {
                reorderedCandidates.add(e.getKey());
                reorderedConfidences.add(e.getValue());
            }
            cr.setHeads(reorderedCandidates);
            cr.setHeadConfidences(reorderedConfidences);
            map.clear();
            int i2 = 0;
            while (i2 < cr.getTails().size()) {
                map.put(cr.getTails().get(i2), cr.getTailConfidences().get(i2));
                ++i2;
            }
            ResultSet.orderByValueDescending(map);
            ArrayList<String> reorderedCandidates2 = new ArrayList<String>();
            ArrayList<Double> reorderedConfidences2 = new ArrayList<Double>();
            for (Map.Entry<String, Double> e : map.entrySet()) {
                reorderedCandidates2.add(e.getKey());
                reorderedConfidences2.add(e.getValue());
            }
            cr.setTails(reorderedCandidates2);
            cr.setTailConfidences(reorderedConfidences2);
        }
    }
}

