/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.playground;

import de.unima.ki.anyburl.io.RuleReader;
import de.unima.ki.anyburl.structure.Rule;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;

public class AmieConverter {
    public static String[] vars = new String[]{"X", "A", "B", "C", "D", "E"};

    public static void main(String[] args) throws IOException {
        String inputPath = "exp/large-final/amie/amie-amf-yago-maxad4-rules.txt";
        String outputPath = "exp/large-final/amie/amie-abf-yago-maxad4-rules-new-xxx.txt";
        PrintWriter pw = new PrintWriter(outputPath);
        RuleReader rr = new RuleReader();
        AmieConverter.convertFile(rr, pw, inputPath);
    }

    public static void convertFile(RuleReader rr, PrintWriter pw, String inputPath) throws IOException {
        File file = new File(inputPath);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        int validRuleCounter = 0;
        int invalidRuleCounter = 0;
        try {
            String line = br.readLine();
            while (line != null) {
                if (line == null) break;
                if (line.equals("")) {
                    break;
                }
                if (line.startsWith("?")) {
                    Rule r = AmieConverter.convertLine(rr, line);
                    if (r == null) {
                        ++invalidRuleCounter;
                    } else {
                        pw.write(String.valueOf(r.toString()) + "\n");
                        ++validRuleCounter;
                    }
                }
                line = br.readLine();
            }
        }
        finally {
            br.close();
        }
        pw.flush();
        pw.close();
        System.out.println("converted amie rule file, valid rules = " + validRuleCounter + ", invalid rules = " + invalidRuleCounter + ".");
    }

    public static Rule convertLine(RuleReader rr, String line) {
        StringBuilder sb = new StringBuilder("");
        String[] parts = line.split("\t");
        String[] hb = parts[0].split("   => ");
        String body = hb[0];
        String head = hb[1];
        int correctlyPredicted = Integer.parseInt(parts[4]);
        int predicted = Integer.parseInt(parts[5]);
        sb.append(String.valueOf(predicted) + "\t");
        sb.append(String.valueOf(correctlyPredicted) + "\t");
        sb.append(String.valueOf((double)correctlyPredicted / (double)predicted) + "\t");
        String[] headToken = head.split("  ");
        String xVar = headToken[0];
        String targetRelation = headToken[1];
        String yVar = headToken[2];
        sb.append(String.valueOf(targetRelation) + "(X,Y) <= ");
        String[] bodyToken = body.split("  ");
        String v = xVar;
        String xc = "none";
        int counter = 0;
        while (!v.equals(yVar)) {
            int ni = AmieConverter.getIndexOfExcluded(v, xc, bodyToken);
            if (ni == -1) {
                return null;
            }
            int indexAtom = ni / 3;
            int indexWithinAtom = ni % 3;
            int otherIndexWithinAtom = indexWithinAtom == 0 ? 2 : 0;
            int no = otherIndexWithinAtom + indexAtom * 3;
            int relationIndex = indexAtom * 3 + 1;
            String relation = bodyToken[relationIndex];
            xc = v;
            v = bodyToken[no];
            String v1 = vars[counter];
            String v2 = vars[counter + 1];
            if (v.equals(yVar)) {
                v2 = "Y";
            }
            if (indexWithinAtom == 2) {
                String tmp = v1;
                v1 = v2;
                v2 = tmp;
            }
            sb.append(String.valueOf(relation) + "(" + v1 + "," + v2 + ")");
            if (!v.equals(yVar)) {
                sb.append(", ");
            }
            ++counter;
        }
        if (bodyToken.length / 3 == counter) {
            Rule r = rr.getRule(sb.toString());
            return r;
        }
        return null;
    }

    private static int getIndexOfExcluded(String var, String excluded, String[] token) {
        int i = 0;
        while (i < token.length) {
            int indexWithinAtom;
            int atomIndex;
            int otherIndexWithinAtom;
            if (token[i].equals(var) && !token[otherIndexWithinAtom = (atomIndex = i / 3) * 3 + ((indexWithinAtom = i % 3) == 0 ? 2 : 0)].equals(excluded)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void read() {
        Scanner scan = new Scanner(System.in);
        scan.nextLine();
    }
}

