/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.playground;

import de.unima.ki.anyburl.data.TripleSet;
import de.unima.ki.anyburl.eval.CompletionResult;
import de.unima.ki.anyburl.eval.ResultSet;

public class ComparisonResultSets {
    public static void main(String[] args) {
        ResultSet rs1 = new ResultSet("RESCAL", "exp/fb237-analysis/dog-rescal-predictions-20-filtered", true, 20);
        ResultSet rs2 = new ResultSet("AnyBURL", "exp/zero/fb237-predictions-1000-all-x-F-top200", true, 200);
        TripleSet train = new TripleSet("data/FB15-237/train.txt");
        boolean tp2TailCounter = false;
        for (CompletionResult cr1 : rs1) {
            String tp;
            CompletionResult cr2 = rs2.getCompletionResult(cr1.getTripleAsString());
            if (cr1.getTails().size() <= 0 || !cr1.isTrueTail(tp = cr1.getTails().get(0))) continue;
            int foundAt = -1;
            double lastConf = -1.0;
            int i = 0;
            while (i < cr2.getTails().size()) {
                if (cr2.getTails().get(i).equals(tp)) {
                    foundAt = i;
                    break;
                }
                lastConf = cr2.getTailConfidences().get(i);
                ++i;
            }
            if (foundAt >= 0) continue;
            System.out.println("correct (in tail pos / in head pos):   " + train.getTriplesByTail(tp).size() + " | " + train.getTriplesByHead(tp).size());
            System.out.println(">>>" + cr1.getTripleAsString());
            System.out.println("must have confidence lower than: " + lastConf);
            System.out.println("---> ");
            i = 0;
            while (i < cr2.getTails().size()) {
                System.out.print("(" + cr2.getTailConfidences().get(i) + ")" + cr2.getTails().get(i) + " ");
                ++i;
            }
            System.out.println();
            System.out.println("");
        }
    }
}

