/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.playground;

import de.unima.ki.anyburl.Settings;
import de.unima.ki.anyburl.data.Triple;
import de.unima.ki.anyburl.data.TripleSet;
import de.unima.ki.anyburl.eval.CompletionResult;
import de.unima.ki.anyburl.eval.ResultSet;
import de.unima.ki.anyburl.io.RuleReader;
import de.unima.ki.anyburl.structure.Rule;
import de.unima.ki.anyburl.structure.RuleAcyclic1;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;

public class NegationFilter {
    public static void main(String[] args) throws IOException {
        String inputRSPath = "exp/wave2/negation/fb237-predictions-1000";
        String outputRSPath = "exp/wave2/negation/fb237-50-filtered-hard";
        RuleReader rr = new RuleReader();
        TripleSet train = new TripleSet("data/FB15-237/train.txt");
        Settings.READ_THRESHOLD_CONFIDENCE = 0.0;
        Settings.READ_THRESHOLD_CORRECT_PREDICTIONS = 0;
        LinkedList<Rule> rules = rr.read("exp/wave2/negation/nrules_s2");
        HashMap relation2Rules = new HashMap();
        for (Rule r : rules) {
            if (!relation2Rules.containsKey(r.getTargetRelation())) {
                relation2Rules.put(r.getTargetRelation(), new LinkedList());
            }
            ((LinkedList)relation2Rules.get(r.getTargetRelation())).add(r);
        }
        System.out.println(rules.size());
        ResultSet rs = new ResultSet("fb237-default", inputRSPath, true, 50);
        int counter = 0;
        int counterAllHeadCandidates = 0;
        int counterAllTailCandidates = 0;
        int filteredHead = 0;
        int filteredTail = 0;
        int correctlyFilteredHead = 0;
        int correctlyFilteredTail = 0;
        HashMap ruleToMistakeCount = new HashMap();
        for (CompletionResult cr : rs) {
            RuleAcyclic1 rule;
            boolean filter;
            String tripleAsString;
            String[] token;
            Triple triple;
            LinkedList relevantRules;
            if (counter % 1000 == 0) {
                System.out.println(String.valueOf(counter) + " completion tasks have been filtered");
            }
            if ((relevantRules = (LinkedList)relation2Rules.get((triple = new Triple((token = (tripleAsString = cr.getTripleAsString()).split("\\s+"))[0], token[1], token[2])).getRelation())) == null) {
                relevantRules = new LinkedList();
            }
            ++counter;
            int hi = 0;
            while (hi < cr.getHeads().size()) {
                String h = cr.getHeads().get(hi);
                ++counterAllHeadCandidates;
                filter = false;
                for (Rule r : relevantRules) {
                    if (r instanceof RuleAcyclic1 && (filter = (rule = (RuleAcyclic1)r).validates(h, triple.getRelation(), triple.getTail(), train))) break;
                }
                if (filter) {
                    String removedElement = cr.getHeads().remove(hi);
                    cr.getHeadConfidences().remove(hi);
                    --hi;
                    ++filteredHead;
                    if (!h.equals(triple.getHead())) {
                        ++correctlyFilteredHead;
                    }
                }
                ++hi;
            }
            int ti = 0;
            while (ti < cr.getTails().size()) {
                String t = cr.getTails().get(ti);
                ++counterAllTailCandidates;
                filter = false;
                for (Rule r : relevantRules) {
                    if (r instanceof RuleAcyclic1 && (filter = (rule = (RuleAcyclic1)r).validates(triple.getHead(), triple.getRelation(), t, train))) break;
                }
                if (filter) {
                    cr.getTails().remove(ti);
                    cr.getTailConfidences().remove(ti);
                    --ti;
                    ++filteredTail;
                    if (!t.equals(triple.getTail())) {
                        ++correctlyFilteredTail;
                    }
                }
                ++ti;
            }
        }
        rs.write(outputRSPath);
        System.out.println("all completion tasks: " + counter);
        System.out.println("random selection mistake rate: " + 2.0 * (double)counter / (double)(counterAllHeadCandidates + counterAllTailCandidates));
        double removalRate1 = (double)(filteredHead + filteredTail) / (double)(counterAllHeadCandidates + counterAllTailCandidates);
        double removalRate2 = (double)(filteredHead + filteredTail) / ((double)counter * 2.0);
        System.out.println("removal rate: " + removalRate1 + " (per candidate) or " + removalRate2 + " per task");
        double misHead = 1.0 - (double)correctlyFilteredHead / (double)filteredHead;
        double misTail = 1.0 - (double)correctlyFilteredTail / (double)filteredTail;
        System.out.println("filtered heads: " + filteredHead + " correctly filtered: " + correctlyFilteredHead + " mistake-rate: " + misHead);
        System.out.println("filtered tails: " + filteredTail + " correctly filtered: " + correctlyFilteredTail + " mistake-rate: " + misTail);
    }
}

