/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.playground;

import de.unima.ki.anyburl.data.Triple;
import de.unima.ki.anyburl.data.TripleSet;
import de.unima.ki.anyburl.structure.Atom;
import de.unima.ki.anyburl.structure.RuleAcyclic1;
import de.unima.ki.anyburl.structure.RuleUntyped;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class NegationLearner {
    public static int MIN_USAGE_RELATION = 500;
    public static int SAMPLE_SIZE = 500;
    public static int MIN_USAGE_XATOM = 10;
    public static int MIN_CONNECTEDNESS = 10;
    public static String outputPath = "exp/wave2/negation/nrules_s2";

    public static void main(String[] args) throws FileNotFoundException {
        TripleSet train = new TripleSet("data/FB15-237/train.txt");
        Set<String> relations = train.getRelations();
        ArrayList<Atom> frequentXAtoms = new ArrayList<Atom>();
        PrintWriter pw = new PrintWriter(outputPath);
        for (String r : relations) {
            Atom atom;
            if (train.getTriplesByRelation(r).size() < MIN_USAGE_RELATION) continue;
            HashMap<String, Integer> headCount = new HashMap<String, Integer>();
            HashMap tailCount = new HashMap();
            ArrayList<String> heads = train.selectNRandomEntitiesByRelation(r, true, SAMPLE_SIZE);
            ArrayList<String> tails = train.selectNRandomEntitiesByRelation(r, false, SAMPLE_SIZE);
            for (String h : heads) {
                if (!headCount.containsKey(h)) {
                    headCount.put(h, 0);
                }
                headCount.put(h, (Integer)headCount.get(h) + 1);
            }
            for (String t : tails) {
                if (!tailCount.containsKey(t)) {
                    tailCount.put(t, 0);
                }
                tailCount.put(t, (Integer)tailCount.get(t) + 1);
            }
            for (String h : headCount.keySet()) {
                if ((Integer)headCount.get(h) < MIN_USAGE_XATOM) continue;
                atom = new Atom(h, r, "X", true, false);
                frequentXAtoms.add(atom);
            }
            for (String t : tailCount.keySet()) {
                if ((Integer)tailCount.get(t) < MIN_USAGE_XATOM) continue;
                atom = new Atom("X", r, t, false, true);
                frequentXAtoms.add(atom);
            }
        }
        System.out.println("found " + frequentXAtoms.size() + " frequent atoms");
        HashSet<Atom> strippedXAtomsAsSet = new HashSet<Atom>();
        ArrayList<Atom> strippedXAtoms = new ArrayList<Atom>();
        for (Atom fxa : frequentXAtoms) {
            Atom stripped;
            if (fxa.isRightC()) {
                stripped = new Atom(fxa.getLeft(), fxa.getRelation(), "something", false, true);
                strippedXAtomsAsSet.add(stripped);
                continue;
            }
            stripped = new Atom("something", fxa.getRelation(), fxa.getRight(), true, false);
            strippedXAtomsAsSet.add(stripped);
        }
        strippedXAtoms.addAll(strippedXAtomsAsSet);
        System.out.println("reduced to " + strippedXAtoms.size() + " stripped atom patterns");
        HashMap validNegativePatterns = new HashMap();
        int countPotentialNegations = 0;
        int i = 0;
        while (i < strippedXAtoms.size() - 1) {
            int j = i + 1;
            while (j < strippedXAtoms.size()) {
                Atom ai = (Atom)strippedXAtoms.get(i);
                Atom aj = (Atom)strippedXAtoms.get(j);
                HashSet<String> distinctJoinValues = new HashSet<String>();
                int counter = 0;
                ArrayList<Triple> aiTriples = train.getTriplesByRelation(ai.getRelation());
                for (Triple aiT : aiTriples) {
                    String joinValue = ai.isRightC() ? aiT.getHead() : aiT.getTail();
                    Set<String> result = train.getEntities(aj.getRelation(), joinValue, aj.isRightC());
                    if (result.size() <= 0) continue;
                    distinctJoinValues.add(joinValue);
                    ++counter;
                }
                if (distinctJoinValues.size() >= MIN_CONNECTEDNESS) {
                    if (!validNegativePatterns.containsKey(ai)) {
                        validNegativePatterns.put(ai, new HashSet());
                    }
                    ((HashSet)validNegativePatterns.get(ai)).add(aj);
                    if (!validNegativePatterns.containsKey(aj)) {
                        validNegativePatterns.put(aj, new HashSet());
                    }
                    ((HashSet)validNegativePatterns.get(aj)).add(ai);
                    ++countPotentialNegations;
                }
                ++j;
            }
            ++i;
        }
        System.out.println("there are potentially " + countPotentialNegations + " patterns for negative rules");
        int countInstValidNegativePatterns = 0;
        int i2 = 0;
        while (i2 < frequentXAtoms.size() - 1) {
            int j = i2 + 1;
            while (j < frequentXAtoms.size()) {
                Atom ai = (Atom)frequentXAtoms.get(i2);
                Atom aj = (Atom)frequentXAtoms.get(j);
                Atom sai = ai.createCopy();
                sai.replace(ai.getConstant(), "something");
                Atom saj = aj.createCopy();
                saj.replace(aj.getConstant(), "something");
                if (validNegativePatterns.containsKey(sai) && ((HashSet)validNegativePatterns.get(sai)).contains(saj)) {
                    ++countInstValidNegativePatterns;
                    Set<String> xIValues = train.getEntities(ai.getRelation(), ai.getConstant(), ai.isLeftC());
                    Set<String> xJValues = train.getEntities(aj.getRelation(), aj.getConstant(), aj.isLeftC());
                    HashSet<String> xIxJValues = new HashSet<String>();
                    xIxJValues.addAll(xIValues);
                    xIxJValues.retainAll(xJValues);
                    if (xIxJValues.size() == 0) {
                        RuleUntyped ui = new RuleUntyped(xIValues.size(), 0, 0.0);
                        ui.setHead(aj);
                        ui.addBodyAtom(ai);
                        RuleAcyclic1 ri = new RuleAcyclic1(ui);
                        ri.detachAndPolish();
                        RuleUntyped uj = new RuleUntyped(xJValues.size(), 0, 0.0);
                        uj.setHead(ai);
                        uj.addBodyAtom(aj);
                        RuleAcyclic1 rj = new RuleAcyclic1(uj);
                        rj.detachAndPolish();
                        pw.println(ri);
                        pw.println(rj);
                        pw.flush();
                        int c = 0;
                        System.out.println("SCORES: " + xIValues.size() + " | " + xJValues.size());
                        System.out.println(ai);
                        for (String xi : xIValues) {
                            System.out.println("   x = " + xi);
                            if (++c == 3) break;
                        }
                        c = 0;
                        System.out.println(aj);
                        for (String xj : xJValues) {
                            System.out.println("   x = " + xj);
                            if (++c == 3) break;
                        }
                        System.out.println();
                    }
                }
                ++j;
            }
            ++i2;
        }
        System.out.println("there are " + countInstValidNegativePatterns + " instantiations of valid negative patterns");
        pw.close();
    }
}

