/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.structure;

import de.unima.ki.anyburl.Settings;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Random;

public class Dice {
    private String OUTPUT_PATH = null;
    private static final int SUPPORTED_TYPES = 14;
    private static final int SUPPORTED_TYPES_CYCLIC = 10;
    private static final double GAMMA = 1.0E-4;
    private static final double INITIAL_SCORE = 1.1984620899082106E307;
    private ArrayList<Long> timestamps = new ArrayList();
    private ArrayList<Double[]> scores = new ArrayList();
    private ArrayList<Integer[]> freqs = new ArrayList();
    private double[] currentScores = new double[14];
    private int[] currentFreqs = new int[14];
    private double[] relevantScores = new double[14];
    private boolean relevantScoresComputed = false;
    private static Random rand = new Random();

    public static void main(String[] args) {
        int numOfThreads = 10;
        Dice dice = new Dice();
        int round = 0;
        while (round < 40) {
            System.out.println("ROUND " + round);
            dice.computeRelevenatScores();
            dice.saveScores();
            System.out.println("DICE: " + dice);
            int[] thread = new int[numOfThreads];
            int i = 0;
            while (i < numOfThreads) {
                int type;
                thread[i] = type = dice.ask(0);
                ++i;
            }
            dice.resetScores();
            int t = 0;
            while (t < thread.length) {
                double s = Dice.simulateScore(thread[t]);
                dice.addScore(thread[t], s);
                ++t;
            }
            ++round;
        }
    }

    public static double simulateScore(int type) {
        if (type == 3) {
            return 100.0 + rand.nextDouble() * 10.0;
        }
        if (type == 5) {
            return 500.0 + rand.nextDouble() * 10.0;
        }
        return 10.0 + rand.nextDouble() * 10.0;
    }

    public Dice() {
        this(null);
    }

    public Dice(String filePath) {
        this.OUTPUT_PATH = filePath;
        int i = 0;
        while (i < 14) {
            this.currentScores[i] = 1.1984620899082106E307;
            this.currentFreqs[i] = 1;
            ++i;
        }
        if (!Settings.ZERO_RULES_ACTIVE) {
            this.currentScores[0] = 0.0;
        }
        int j = Settings.MAX_LENGTH_CYCLIC + 1;
        while (j < 11) {
            this.currentScores[j] = 0.0;
            ++j;
        }
        j = 11 + Settings.MAX_LENGTH_ACYCLIC;
        while (j < 14) {
            this.currentScores[j] = 0.0;
            ++j;
        }
    }

    public int ask(int batchCounter) {
        double r = (Settings.RANDOMIZED_DECISIONS_ANNEALING - (double)batchCounter) / Settings.RANDOMIZED_DECISIONS_ANNEALING;
        if (r < Settings.EPSILON) {
            r = Settings.EPSILON;
        }
        if (rand.nextDouble() < r) {
            int i;
            do {
                i = rand.nextInt(14);
            } while (this.scores.get(0)[i] == 0.0);
            return i;
        }
        if (Settings.POLICY == 1) {
            double max = -100.0;
            int maxIndex = -1;
            int i = 0;
            while (i < 14) {
                double score = this.relevantScores[i];
                if (score > max) {
                    maxIndex = i;
                    max = score;
                }
                ++i;
            }
            return maxIndex;
        }
        if (Settings.POLICY == 2) {
            if (!this.relevantScoresComputed) {
                throw new RuntimeException("before asking the dice you have to compute the relevant scores");
            }
            double total = 0.0;
            int i = 0;
            while (i < 14) {
                total += this.relevantScores[i];
                ++i;
            }
            double d = rand.nextDouble() * total;
            int i2 = 0;
            while (i2 < 14) {
                if (d < this.relevantScores[i2]) {
                    return i2;
                }
                d -= this.relevantScores[i2];
                ++i2;
            }
        }
        return 0;
    }

    public void computeRelevenatScores() {
        int i = 0;
        while (i < 14) {
            if (this.currentScores[i] > 0.0) {
                this.relevantScores[i] = this.currentScores[i] / (double)this.currentFreqs[i];
            }
            ++i;
        }
        this.relevantScoresComputed = true;
    }

    public void resetScores() {
        int i = 0;
        while (i < 14) {
            this.currentScores[i] = 0.0;
            this.currentFreqs[i] = 0;
            ++i;
        }
        this.relevantScoresComputed = false;
    }

    public synchronized void addScore(int index, double score) {
        int n = index;
        this.currentScores[n] = this.currentScores[n] + score;
        int n2 = index;
        this.currentFreqs[n2] = this.currentFreqs[n2] + 1;
        if (score == 0.0) {
            int n3 = index;
            this.currentScores[n3] = this.currentScores[n3] + 1.0E-4;
        }
    }

    public void saveScores() {
        this.scores.add(new Double[14]);
        this.freqs.add(new Integer[14]);
        this.timestamps.add(System.currentTimeMillis());
        Double[] lastScores = this.scores.get(this.scores.size() - 1);
        Integer[] lastFreqs = this.freqs.get(this.scores.size() - 1);
        int i = 0;
        while (i < this.currentScores.length) {
            lastFreqs[i] = this.currentFreqs[i];
            lastScores[i] = this.currentScores[i] / (double)(lastFreqs[i] > 0 ? lastFreqs[i] : 1);
            ++i;
        }
    }

    public static boolean decodedDiceCyclic(int dice) {
        return dice >= 0 && dice < 11;
    }

    public static boolean decodedDiceAcyclic(int dice) {
        return dice >= 11;
    }

    public static boolean decodedDiceZero(int dice) {
        return dice == 0;
    }

    public static int decodedDiceLength(int dice) {
        if (dice == 0) {
            return 0;
        }
        if (Dice.decodedDiceCyclic(dice)) {
            return dice;
        }
        return dice - 10;
    }

    public static int encode(boolean zero, boolean cyclic, boolean acyclic, int len) {
        if (len == 0) {
            return 0;
        }
        if (cyclic) {
            return len;
        }
        return 10 + len;
    }

    public void write(String suffix) {
        if (this.OUTPUT_PATH == null) {
            return;
        }
        try {
            PrintWriter pw = new PrintWriter(String.valueOf(this.OUTPUT_PATH) + "_" + suffix);
            int n = 0;
            while (n < this.scores.size()) {
                pw.print(this.timestamps.get(n));
                int i = 0;
                while (i < 14) {
                    pw.print("\t" + this.scores.get(n)[i]);
                    ++i;
                }
                i = 0;
                while (i < 14) {
                    pw.print("\t" + this.freqs.get(n)[i]);
                    ++i;
                }
                pw.print("\n");
                ++n;
            }
            pw.flush();
            pw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        DecimalFormat df = new DecimalFormat("000000");
        StringBuilder sb = new StringBuilder("");
        int i = 0;
        while (i < 14) {
            if (i == 1) {
                sb.append(" |");
            }
            if ((i < Settings.MAX_LENGTH_CYCLIC + 1 || i >= 11) && i - 11 < Settings.MAX_LENGTH_ACYCLIC) {
                if (i == 11) {
                    sb.append(" |");
                }
                double s = this.relevantScores[i];
                sb.append(" " + (s > 999999.0 ? " > 99k" : df.format(s)));
            }
            ++i;
        }
        return sb.toString();
    }
}

