/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.structure;

import de.unima.ki.anyburl.data.Triple;
import java.util.HashSet;

public class Path {
    protected String[] nodes;
    protected char[] markers;

    public Path(String[] nodes, char[] markers) {
        this.nodes = nodes;
        this.markers = markers;
    }

    public String toString() {
        StringBuilder p = new StringBuilder("");
        int i = 0;
        while (i < this.nodes.length - 1) {
            p.append(this.markedNodeToString(i));
            p.append(" -> ");
            ++i;
        }
        p.append(this.markedNodeToString(this.nodes.length - 1));
        return p.toString();
    }

    private String markedNodeToString(int i) {
        if (i % 2 == 1) {
            return String.valueOf(this.markers[(i - 1) / 2]) + this.nodes[i];
        }
        return this.nodes[i];
    }

    public boolean equals(Object that) {
        return false;
    }

    public int hashCode() {
        return 7;
    }

    public boolean isValid() {
        String xconst = this.nodes[0];
        String yconst = this.nodes[2];
        HashSet<String> visitedEntities = new HashSet<String>();
        int i = 4;
        while (i < this.nodes.length - 2) {
            if (this.nodes[i].equals(xconst)) {
                return false;
            }
            if (this.nodes[i].equals(yconst)) {
                return false;
            }
            i += 2;
        }
        i = 2;
        while (i < this.nodes.length) {
            if (visitedEntities.contains(this.nodes[i])) {
                return false;
            }
            visitedEntities.add(this.nodes[i]);
            i += 2;
        }
        return true;
    }

    public boolean isNonCyclic(Triple t) {
        int i = 4;
        while (i < this.nodes.length) {
            if (t.getHead().equals(this.nodes[i])) {
                return false;
            }
            if (t.getTail().equals(this.nodes[i])) {
                return false;
            }
            i += 2;
        }
        return true;
    }

    public boolean isCyclic() {
        return this.nodes[this.nodes.length - 1].equals(this.nodes[0]) || this.nodes[this.nodes.length - 1].equals(this.nodes[2]);
    }
}

