/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.structure;

import de.unima.ki.anyburl.data.Triple;
import de.unima.ki.anyburl.data.TripleSet;
import de.unima.ki.anyburl.structure.Atom;
import de.unima.ki.anyburl.structure.RuleAcyclic;
import de.unima.ki.anyburl.structure.RuleUntyped;
import java.util.HashSet;

public class RuleAcyclic1
extends RuleAcyclic {
    public RuleAcyclic1(RuleUntyped r) {
        super(r);
    }

    @Override
    protected String getUnboundVariable() {
        return null;
    }

    @Override
    public int getGroundingsLastAtom(TripleSet triples) {
        Atom last = this.body.getLast();
        if (last.isRightC()) {
            return triples.getHeadEntities(last.getRelation(), last.getRight()).size();
        }
        return triples.getTailEntities(last.getRelation(), last.getLeft()).size();
    }

    @Override
    public boolean isSingleton(TripleSet triples) {
        if (this.body.get(0).getRight().equals("X") && this.body.get(0).getRight().equals("Y")) {
            String head = this.body.get(0).getLeft();
            String relation = this.body.get(0).getRelation();
            return triples.getTailEntities(relation, head).size() <= 1;
        }
        String tail = this.body.get(0).getRight();
        String relation = this.body.get(0).getRelation();
        return triples.getHeadEntities(relation, tail).size() <= 1;
    }

    public boolean isCyclic() {
        return this.getHead().getConstant().equals(this.body.getLast().getConstant());
    }

    public String toXYString() {
        if (this.head.getLeft().equals("X")) {
            String c = this.head.getRight();
            StringBuilder sb = new StringBuilder();
            sb.append(this.getHead().toString(c, "Y"));
            int i = 0;
            while (i < this.bodysize()) {
                sb.append(this.getBodyAtom(i).toString(c, "Y"));
                ++i;
            }
            String rs = sb.toString();
            return rs;
        }
        if (this.head.getRight().equals("Y")) {
            String c = this.head.getLeft();
            StringBuilder sb = new StringBuilder();
            sb.append(this.getHead().toString(c, "X"));
            int i = this.bodysize() - 1;
            while (i >= 0) {
                sb.append(this.getBodyAtom(i).toString(c, "X"));
                --i;
            }
            String rs = sb.toString();
            return rs;
        }
        System.err.println("toXYString of the following rule not implemented: " + this);
        System.exit(1);
        return null;
    }

    public boolean validates(String h, String relation, String t, TripleSet ts) {
        if (this.getTargetRelation().equals(relation)) {
            if (this.head.isRightC() && this.head.getRight().equals(t)) {
                HashSet<String> previousValues = new HashSet<String>();
                previousValues.add(h);
                previousValues.add(this.head.getRight());
                return this.isBodyTrueAcyclic("X", h, 0, previousValues, ts);
            }
            if (this.head.isLeftC() && this.head.getLeft().equals(h)) {
                HashSet<String> previousValues = new HashSet<String>();
                previousValues.add(t);
                previousValues.add(this.head.getLeft());
                return this.isBodyTrueAcyclic("Y", t, 0, previousValues, ts);
            }
            return false;
        }
        return false;
    }

    @Override
    public HashSet<Triple> getTripleExplanation(String xValue, String yValue, HashSet<Triple> excludedTriples, TripleSet triples) {
        if (this.bodysize() != 1) {
            System.err.println("Trying to get a triple explanation for an acyclic rule with constant in head any body of length != 1. This is not yet implemented.");
            System.exit(-1);
        }
        HashSet<Triple> groundings = new HashSet<Triple>();
        boolean xInHead = false;
        if (this.head.getLeft().equals("X")) {
            xInHead = true;
        }
        if (xInHead) {
            if (this.head.getRight().equals(yValue) || this.head.getRight().equals("me_myself_i") && xValue.equals(yValue)) {
                Triple t;
                String left = this.body.get(0).getLeft();
                String right = this.body.get(0).getRight();
                String rel = this.body.get(0).getRelation();
                if (left.equals("X") && triples.isTrue(xValue, rel, right) && !excludedTriples.contains(t = new Triple(xValue, rel, right))) {
                    groundings.add(t);
                }
                if (right.equals("X") && triples.isTrue(left, rel, xValue) && !excludedTriples.contains(t = new Triple(left, rel, xValue))) {
                    groundings.add(t);
                }
            }
        } else if (this.head.getLeft().equals(xValue) || this.head.getLeft().equals("me_myself_i") && xValue.equals(yValue)) {
            Triple t;
            String left = this.body.get(0).getLeft();
            String right = this.body.get(0).getRight();
            String rel = this.body.get(0).getRelation();
            if (left.equals("Y") && triples.isTrue(yValue, rel, right) && !excludedTriples.contains(t = new Triple(yValue, rel, right))) {
                groundings.add(t);
            }
            if (right.equals("Y") && triples.isTrue(left, rel, yValue) && !excludedTriples.contains(t = new Triple(left, rel, yValue))) {
                groundings.add(t);
            }
        }
        return groundings;
    }
}

