/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.structure;

import de.unima.ki.anyburl.Settings;
import de.unima.ki.anyburl.data.Triple;
import de.unima.ki.anyburl.data.TripleSet;
import de.unima.ki.anyburl.structure.Atom;
import de.unima.ki.anyburl.structure.Rule;
import de.unima.ki.anyburl.structure.RuleAcyclic;
import de.unima.ki.anyburl.structure.RuleUntyped;
import java.util.HashMap;
import java.util.HashSet;

public class RuleAcyclic2
extends RuleAcyclic {
    private String unboundVariable = null;

    public RuleAcyclic2(RuleUntyped r) {
        super(r);
    }

    @Override
    protected String getUnboundVariable() {
        if (this.unboundVariable != null) {
            return this.unboundVariable;
        }
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        for (Atom atom : this.body) {
            if (!atom.getLeft().equals("X") && !atom.getLeft().equals("Y")) {
                if (counter.containsKey(atom.getLeft())) {
                    counter.put(atom.getLeft(), 2);
                } else {
                    counter.put(atom.getLeft(), 1);
                }
            }
            if (atom.getRight().equals("X") || atom.getRight().equals("Y")) continue;
            if (counter.containsKey(atom.getRight())) {
                counter.put(atom.getRight(), 2);
                continue;
            }
            counter.put(atom.getRight(), 1);
        }
        for (String variable : counter.keySet()) {
            if ((Integer)counter.get(variable) != 1) continue;
            this.unboundVariable = variable;
            return variable;
        }
        return this.unboundVariable;
    }

    @Override
    public double getAppliedConfidence() {
        return Settings.RULE_AC2_WEIGHT * super.getAppliedConfidence();
    }

    @Override
    public boolean isSingleton(TripleSet triples) {
        return false;
    }

    @Override
    public int getGroundingsLastAtom(TripleSet triples) {
        String unboundVariable = this.getUnboundVariable();
        Atom last = this.body.getLast();
        if (last.getRight().equals(unboundVariable)) {
            HashSet<String> values = new HashSet<String>();
            for (Triple t : triples.getTriplesByRelation(last.getRelation())) {
                values.add(t.getHead());
                if (values.size() < Settings.AC_MIN_NUM_OF_LAST_ATOM_GROUNDINGS) continue;
                return values.size();
            }
            return values.size();
        }
        HashSet<String> values = new HashSet<String>();
        for (Triple t : triples.getTriplesByRelation(last.getRelation())) {
            values.add(t.getTail());
            if (values.size() < Settings.AC_MIN_NUM_OF_LAST_ATOM_GROUNDINGS) continue;
            return values.size();
        }
        return values.size();
    }

    @Override
    public HashSet<Triple> getTripleExplanation(String xValue, String yValue, HashSet<Triple> excludedTriples, TripleSet triples) {
        System.err.println("Your are asking for a triple explanation using an AC2 rule (a.k.a. U_d rule). Triple explanations for this rule are so far not implemented.");
        return null;
    }

    @Override
    public int[] computeScores(Rule that, TripleSet triples) {
        System.err.println("method not yet available for an untyped rule");
        return new int[2];
    }
}

