/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.structure;

import de.unima.ki.anyburl.Settings;
import de.unima.ki.anyburl.data.SampledPairedResultSet;
import de.unima.ki.anyburl.data.Triple;
import de.unima.ki.anyburl.data.TripleSet;
import de.unima.ki.anyburl.structure.Atom;
import de.unima.ki.anyburl.structure.Rule;
import de.unima.ki.anyburl.structure.RuleUntyped;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class RuleCyclic
extends Rule {
    public RuleCyclic(RuleUntyped r) {
        super(r);
        if (this.body.get(0).contains("Y") && this.bodysize() > 1) {
            int i = 0;
            while (i <= this.bodysize() / 2 - 1) {
                int j = this.bodysize() - i - 1;
                Atom atom_i = this.body.get(i);
                Atom atom_j = this.body.get(j);
                this.body.set(i, atom_j);
                this.body.set(j, atom_i);
                ++i;
            }
            this.body.normalizeVariableNames();
        }
    }

    @Override
    public TripleSet materialize(TripleSet trainingSet) {
        return null;
    }

    @Override
    public HashSet<String> computeTailResults(String head, TripleSet ts) {
        HashSet<String> results = new HashSet<String>();
        this.getCyclic("X", "Y", head, 0, true, ts, new HashSet<String>(), results);
        return results;
    }

    @Override
    public HashSet<String> computeHeadResults(String tail, TripleSet ts) {
        HashSet<String> results = new HashSet<String>();
        this.getCyclic("Y", "X", tail, this.bodysize() - 1, false, ts, new HashSet<String>(), results);
        return results;
    }

    @Override
    public void computeScores(TripleSet triples) {
        SampledPairedResultSet xypairsReverse;
        SampledPairedResultSet xypairs;
        if (this.body.get(0).contains("X")) {
            if (Settings.BEAM_NOT_DFS) {
                xypairs = this.beamBodyCyclicEDIS("X", "Y", triples);
                xypairsReverse = this.beamBodyCyclicReverseEDIS("X", "Y", triples);
            } else {
                xypairs = this.groundBodyCyclic("X", "Y", triples);
                xypairsReverse = new SampledPairedResultSet();
            }
        } else if (Settings.BEAM_NOT_DFS) {
            xypairs = this.beamBodyCyclicEDIS("Y", "X", triples);
            xypairsReverse = this.beamBodyCyclicReverseEDIS("Y", "X", triples);
        } else {
            xypairs = this.groundBodyCyclic("Y", "X", triples);
            xypairsReverse = new SampledPairedResultSet();
        }
        int predictedAll = 0;
        int correctlyPredictedAll = 0;
        int correctlyPredicted = 0;
        int predicted = 0;
        for (String key : xypairsReverse.getValues().keySet()) {
            for (String value : xypairsReverse.getValues().get(key)) {
                ++predicted;
                if (!triples.isTrue(key, this.head.getRelation(), value)) continue;
                ++correctlyPredicted;
            }
        }
        predictedAll += predicted;
        correctlyPredictedAll += correctlyPredicted;
        correctlyPredicted = 0;
        predicted = 0;
        for (String key : xypairs.getValues().keySet()) {
            for (String value : xypairs.getValues().get(key)) {
                ++predicted;
                if (!triples.isTrue(key, this.head.getRelation(), value)) continue;
                ++correctlyPredicted;
            }
        }
        this.predicted = predictedAll += predicted;
        this.correctlyPredicted = correctlyPredictedAll += correctlyPredicted;
        this.confidence = (double)this.correctlyPredicted / (double)this.predicted;
    }

    @Override
    public int[] computeScores(Rule that, TripleSet triples) {
        HashSet<Triple> explanation;
        SampledPairedResultSet xypairsReverse;
        SampledPairedResultSet xypairs;
        int[] scores = new int[2];
        if (!this.getTargetRelation().equals(that.getTargetRelation())) {
            System.err.print("your are computing the scores of a concjuntion of two rules with different target relations, that does not make sense");
            return scores;
        }
        if (this.body.get(0).contains("X")) {
            if (Settings.BEAM_NOT_DFS) {
                xypairs = this.beamBodyCyclicEDIS("X", "Y", triples);
                xypairsReverse = this.beamBodyCyclicReverseEDIS("X", "Y", triples);
            } else {
                xypairsReverse = xypairs = this.groundBodyCyclic("X", "Y", triples);
            }
        } else if (Settings.BEAM_NOT_DFS) {
            xypairs = this.beamBodyCyclicEDIS("Y", "X", triples);
            xypairsReverse = this.beamBodyCyclicReverseEDIS("Y", "X", triples);
        } else {
            xypairsReverse = xypairs = this.groundBodyCyclic("Y", "X", triples);
        }
        int predictedBoth = 0;
        int correctlyPredictedBoth = 0;
        for (String key : xypairs.getValues().keySet()) {
            for (String value : xypairs.getValues().get(key)) {
                explanation = that.getTripleExplanation(key, value, new HashSet<Triple>(), triples);
                if (explanation == null || explanation.size() <= 0) continue;
                ++predictedBoth;
                if (!triples.isTrue(key, this.head.getRelation(), value)) continue;
                ++correctlyPredictedBoth;
            }
        }
        for (String key : xypairsReverse.getValues().keySet()) {
            for (String value : xypairsReverse.getValues().get(key)) {
                explanation = that.getTripleExplanation(key, value, new HashSet<Triple>(), triples);
                if (explanation == null || explanation.size() <= 0) continue;
                ++predictedBoth;
                if (!triples.isTrue(key, this.head.getRelation(), value)) continue;
                ++correctlyPredictedBoth;
            }
        }
        scores[0] = predictedBoth;
        scores[1] = correctlyPredictedBoth;
        return scores;
    }

    @Override
    public Triple getRandomValidPrediction(TripleSet triples) {
        ArrayList<Triple> validPredictions = this.getPredictions(triples, 1);
        if (validPredictions == null || validPredictions.size() == 0) {
            return null;
        }
        if (validPredictions.size() == 0) {
            return null;
        }
        int index = rand.nextInt(validPredictions.size());
        return validPredictions.get(index);
    }

    @Override
    public Triple getRandomInvalidPrediction(TripleSet triples) {
        ArrayList<Triple> validPredictions = this.getPredictions(triples, -1);
        if (validPredictions == null || validPredictions.size() == 0) {
            return null;
        }
        if (validPredictions.size() == 0) {
            return null;
        }
        int index = rand.nextInt(validPredictions.size());
        return validPredictions.get(index);
    }

    @Override
    public ArrayList<Triple> getPredictions(TripleSet triples) {
        return this.getPredictions(triples, 0);
    }

    protected ArrayList<Triple> getPredictions(TripleSet triples, int valid) {
        SampledPairedResultSet xypairs = this.body.get(0).contains("X") ? this.groundBodyCyclic("X", "Y", triples) : this.groundBodyCyclic("Y", "X", triples);
        ArrayList<Triple> predictions = new ArrayList<Triple>();
        for (String key : xypairs.getValues().keySet()) {
            for (String value : xypairs.getValues().get(key)) {
                Triple validPrediction;
                if (valid == 1) {
                    if (!triples.isTrue(key, this.head.getRelation(), value)) continue;
                    validPrediction = new Triple(key, this.head.getRelation(), value);
                    predictions.add(validPrediction);
                    continue;
                }
                if (valid == -1) {
                    if (triples.isTrue(key, this.head.getRelation(), value)) continue;
                    Triple invalidPrediction = new Triple(key, this.head.getRelation(), value);
                    predictions.add(invalidPrediction);
                    continue;
                }
                validPrediction = new Triple(key, this.head.getRelation(), value);
                predictions.add(validPrediction);
            }
        }
        return predictions;
    }

    @Override
    public boolean isPredictedX(String leftValue, String rightValue, Triple forbidden, TripleSet ts) {
        System.err.println("method not YET available for an extended/refinde rule");
        return false;
    }

    private void getCyclic(String currentVariable, String lastVariable, String value, int bodyIndex, boolean direction, TripleSet triples, HashSet<String> previousValues, HashSet<String> finalResults) {
        if (Rule.APPLICATION_MODE && finalResults.size() >= Settings.DISCRIMINATION_BOUND) {
            finalResults.clear();
            return;
        }
        Atom atom = this.body.get(bodyIndex);
        boolean headNotTail = atom.getLeft().equals(currentVariable);
        if (previousValues.contains(value)) {
            return;
        }
        if (direction && this.body.size() - 1 == bodyIndex || !direction && bodyIndex == 0) {
            for (String v : triples.getEntities(atom.getRelation(), value, headNotTail)) {
                if (previousValues.contains(v) || value.equals(v)) continue;
                finalResults.add(v);
            }
            return;
        }
        Set<String> results = triples.getEntities(atom.getRelation(), value, headNotTail);
        if (results.size() > Settings.BRANCHINGFACTOR_BOUND && Settings.DFS_SAMPLING_ON) {
            return;
        }
        String nextVariable = headNotTail ? atom.getRight() : atom.getLeft();
        HashSet<String> currentValues = new HashSet<String>();
        currentValues.addAll(previousValues);
        currentValues.add(value);
        for (String nextValue : results) {
            int updatedBodyIndex = direction ? bodyIndex + 1 : bodyIndex - 1;
            this.getCyclic(nextVariable, lastVariable, nextValue, updatedBodyIndex, direction, triples, currentValues, finalResults);
        }
    }

    private SampledPairedResultSet groundBodyCyclic(String firstVariable, String lastVariable, TripleSet triples) {
        return this.groundBodyCyclic(firstVariable, lastVariable, triples, Settings.DFS_SAMPLING_ON);
    }

    private SampledPairedResultSet groundBodyCyclic(String firstVariable, String lastVariable, TripleSet triples, boolean samplingOn) {
        SampledPairedResultSet groundings = new SampledPairedResultSet();
        Atom atom = this.body.get(0);
        boolean headNotTail = atom.getLeft().equals(firstVariable);
        ArrayList<Triple> rtriples = triples.getTriplesByRelation(atom.getRelation());
        int counter = 0;
        for (Triple t : rtriples) {
            ++counter;
            HashSet<String> lastVariableGroundings = new HashSet<String>();
            this.getCyclic(firstVariable, lastVariable, t.getValue(headNotTail), 0, true, triples, new HashSet<String>(), lastVariableGroundings);
            if (lastVariableGroundings.size() > 0) {
                if (firstVariable.equals("X")) {
                    groundings.addKey(t.getValue(headNotTail));
                    for (String lastVariableValue : lastVariableGroundings) {
                        groundings.addValue(lastVariableValue);
                    }
                } else {
                    for (String lastVariableValue : lastVariableGroundings) {
                        groundings.addKey(lastVariableValue);
                        groundings.addValue(t.getValue(headNotTail));
                    }
                }
            }
            if ((counter > Settings.SAMPLE_SIZE || groundings.size() > Settings.SAMPLE_SIZE) && samplingOn) break;
        }
        return groundings;
    }

    private SampledPairedResultSet beamBodyCyclic(String firstVariable, String lastVariable, TripleSet triples) {
        Triple t;
        SampledPairedResultSet groundings = new SampledPairedResultSet();
        Atom atom = this.body.get(0);
        boolean headNotTail = atom.getLeft().equals(firstVariable);
        int attempts = 0;
        int repetitions = 0;
        while ((t = triples.getRandomTripleByRelation(atom.getRelation())) != null) {
            ++attempts;
            String lastVarGrounding = this.beamCyclic(firstVariable, t.getValue(headNotTail), 0, true, triples, new HashSet<String>());
            if (lastVarGrounding != null) {
                if (firstVariable.equals("X")) {
                    groundings.addKey(t.getValue(headNotTail));
                    repetitions = groundings.addValue(lastVarGrounding) ? 0 : ++repetitions;
                } else {
                    groundings.addKey(lastVarGrounding);
                    repetitions = groundings.addValue(t.getValue(headNotTail)) ? 0 : ++repetitions;
                }
            }
            if (Settings.BEAM_SAMPLING_MAX_REPETITIONS <= repetitions || Settings.BEAM_SAMPLING_MAX_BODY_GROUNDING_ATTEMPTS <= attempts || Settings.BEAM_SAMPLING_MAX_BODY_GROUNDINGS <= groundings.size()) break;
        }
        return groundings;
    }

    private SampledPairedResultSet beamBodyCyclicEDIS(String firstVariable, String lastVariable, TripleSet triples) {
        SampledPairedResultSet groundings = new SampledPairedResultSet();
        Atom atom = this.body.get(0);
        boolean headNotTail = atom.getLeft().equals(firstVariable);
        int repetitions = 0;
        ArrayList<String> entities = triples.getNRandomEntitiesByRelation(atom.getRelation(), headNotTail, Settings.BEAM_SAMPLING_MAX_BODY_GROUNDING_ATTEMPTS);
        for (String e : entities) {
            String lastVarGrounding = this.beamCyclic(firstVariable, e, 0, true, triples, new HashSet<String>());
            if (lastVarGrounding != null) {
                if (firstVariable.equals("X")) {
                    groundings.addKey(e);
                    repetitions = groundings.addValue(lastVarGrounding) ? 0 : ++repetitions;
                } else {
                    groundings.addKey(lastVarGrounding);
                    repetitions = groundings.addValue(e) ? 0 : ++repetitions;
                }
            }
            if (Settings.BEAM_SAMPLING_MAX_REPETITIONS <= repetitions || Settings.BEAM_SAMPLING_MAX_BODY_GROUNDINGS <= groundings.size()) break;
        }
        groundings.setChaoEstimate(repetitions);
        return groundings;
    }

    public int getChaoEstimate(int f1, int f2, int d) {
        return (int)((double)d + (double)(f1 * f1) / (2.0 * (double)f2));
    }

    private SampledPairedResultSet beamBodyCyclicReverse(String firstVariable, String lastVariable, TripleSet triples) {
        Triple t;
        SampledPairedResultSet groundings = new SampledPairedResultSet();
        Atom atom = this.body.getLast();
        boolean headNotTail = atom.getLeft().equals(lastVariable);
        int attempts = 0;
        int repetitions = 0;
        while ((t = triples.getRandomTripleByRelation(atom.getRelation())) != null) {
            ++attempts;
            String firstVarGrounding = this.beamCyclic(lastVariable, t.getValue(headNotTail), this.bodysize() - 1, false, triples, new HashSet<String>());
            if (firstVarGrounding != null) {
                if (firstVariable.equals("X")) {
                    groundings.addKey(firstVarGrounding);
                    repetitions = groundings.addValue(t.getValue(headNotTail)) ? 0 : ++repetitions;
                } else {
                    groundings.addKey(t.getValue(headNotTail));
                    repetitions = groundings.addValue(firstVarGrounding) ? 0 : ++repetitions;
                }
            }
            if (Settings.BEAM_SAMPLING_MAX_REPETITIONS <= repetitions || Settings.BEAM_SAMPLING_MAX_BODY_GROUNDING_ATTEMPTS <= attempts || Settings.BEAM_SAMPLING_MAX_BODY_GROUNDINGS <= groundings.size()) break;
        }
        return groundings;
    }

    private SampledPairedResultSet beamBodyCyclicReverseEDIS(String firstVariable, String lastVariable, TripleSet triples) {
        SampledPairedResultSet groundings = new SampledPairedResultSet();
        Atom atom = this.body.getLast();
        boolean headNotTail = atom.getLeft().equals(lastVariable);
        int repetitions = 0;
        ArrayList<String> entities = triples.getNRandomEntitiesByRelation(atom.getRelation(), headNotTail, Settings.BEAM_SAMPLING_MAX_BODY_GROUNDING_ATTEMPTS);
        for (String e : entities) {
            String firstVarGrounding = this.beamCyclic(lastVariable, e, this.bodysize() - 1, false, triples, new HashSet<String>());
            if (firstVarGrounding != null) {
                if (firstVariable.equals("X")) {
                    groundings.addKey(firstVarGrounding);
                    repetitions = groundings.addValue(e) ? 0 : ++repetitions;
                } else {
                    groundings.addKey(e);
                    repetitions = groundings.addValue(firstVarGrounding) ? 0 : ++repetitions;
                }
            }
            if (Settings.BEAM_SAMPLING_MAX_REPETITIONS <= repetitions || Settings.BEAM_SAMPLING_MAX_BODY_GROUNDINGS <= groundings.size()) break;
        }
        return groundings;
    }

    protected String beamCyclic(String currentVariable, String value, int bodyIndex, boolean direction, TripleSet triples, HashSet<String> previousValues) {
        if (value == null) {
            return null;
        }
        Atom atom = this.body.get(bodyIndex);
        boolean headNotTail = atom.getLeft().equals(currentVariable);
        if (previousValues.contains(value)) {
            return null;
        }
        if (direction && this.body.size() - 1 == bodyIndex || !direction && bodyIndex == 0) {
            String finalValue = triples.getRandomEntity(atom.getRelation(), value, headNotTail);
            if (previousValues.contains(finalValue)) {
                return null;
            }
            if (value.equals(finalValue)) {
                return null;
            }
            return finalValue;
        }
        String nextValue = triples.getRandomEntity(atom.getRelation(), value, headNotTail);
        String nextVariable = headNotTail ? atom.getRight() : atom.getLeft();
        previousValues.add(value);
        int updatedBodyIndex = direction ? bodyIndex + 1 : bodyIndex - 1;
        return this.beamCyclic(nextVariable, nextValue, updatedBodyIndex, direction, triples, previousValues);
    }

    @Override
    public boolean isRefinable() {
        return true;
    }

    @Override
    public double getAppliedConfidence() {
        double cop = this.getCorrectlyPredicted();
        double pred = this.getPredicted();
        double rsize = this.bodysize();
        return cop / (pred + (double)Settings.UNSEEN_NEGATIVE_EXAMPLES);
    }

    @Override
    public boolean isSingleton(TripleSet triples) {
        return false;
    }

    @Override
    public HashSet<Triple> getTripleExplanation(String xValue, String yValue, HashSet<Triple> excludedTriples, TripleSet triples) {
        HashSet<Triple> groundings = new HashSet<Triple>();
        ArrayList<Atom> bodyAtoms = new ArrayList<Atom>();
        ArrayList<String> variables = new ArrayList<String>();
        int i = 0;
        while (i < this.bodysize()) {
            bodyAtoms.add(this.getBodyAtom(i));
            ++i;
        }
        variables.add("X");
        i = 0;
        while (i < this.bodysize() - 1) {
            variables.add(Rule.variables[i]);
            ++i;
        }
        variables.add("Y");
        HashSet<String> visitedValues = new HashSet<String>();
        visitedValues.add(xValue);
        visitedValues.add(yValue);
        this.searchTripleExplanation(xValue, yValue, 0, this.bodysize() - 1, variables, excludedTriples, triples, groundings, visitedValues);
        return groundings;
    }

    private void searchTripleExplanation(String firstValue, String lastValue, int firstIndex, int lastIndex, ArrayList<String> variables, HashSet<Triple> excludedTriples, TripleSet triples, HashSet<Triple> groundings, HashSet<String> visitedValues) {
        boolean lastValuesAreTails;
        boolean firstValuesAreTails;
        String firstVar = variables.get(firstIndex);
        String lastVar = variables.get(lastIndex + 1);
        if (firstIndex == lastIndex) {
            Triple g;
            Atom atom = this.getBodyAtom(firstIndex);
            if (atom.getLeft().equals(firstVar)) {
                Triple g2;
                if (triples.isTrue(firstValue, atom.getRelation(), lastValue) && !excludedTriples.contains(g2 = new Triple(firstValue, atom.getRelation(), lastValue))) {
                    groundings.add(g2);
                }
            } else if (triples.isTrue(lastValue, atom.getRelation(), firstValue) && !excludedTriples.contains(g = new Triple(lastValue, atom.getRelation(), firstValue))) {
                groundings.add(g);
            }
            return;
        }
        Atom firstAtom = this.getBodyAtom(firstIndex);
        Atom lastAtom = this.getBodyAtom(lastIndex);
        Set<String> valuesFromFirst = null;
        if (firstAtom.getLeft().equals(firstVar)) {
            valuesFromFirst = triples.getTailEntities(firstAtom.getRelation(), firstValue);
            firstValuesAreTails = true;
        } else {
            valuesFromFirst = triples.getHeadEntities(firstAtom.getRelation(), firstValue);
            firstValuesAreTails = false;
        }
        Set<String> valuesFromLast = null;
        if (lastAtom.getLeft().equals(lastVar)) {
            valuesFromLast = triples.getTailEntities(lastAtom.getRelation(), lastValue);
            lastValuesAreTails = true;
        } else {
            valuesFromLast = triples.getHeadEntities(lastAtom.getRelation(), lastValue);
            lastValuesAreTails = false;
        }
        if (valuesFromFirst.size() < valuesFromLast.size()) {
            for (String value : valuesFromFirst) {
                Triple g = firstValuesAreTails ? new Triple(firstValue, firstAtom.getRelation(), value) : new Triple(value, firstAtom.getRelation(), firstValue);
                if (excludedTriples.contains(g) || visitedValues.contains(value)) continue;
                groundings.add(g);
                visitedValues.add(value);
                this.searchTripleExplanation(value, lastValue, firstIndex + 1, lastIndex, variables, excludedTriples, triples, groundings, visitedValues);
                if (groundings.size() < this.bodysize()) {
                    groundings.remove(g);
                    continue;
                }
                break;
            }
        } else {
            for (String value : valuesFromLast) {
                Triple g = lastValuesAreTails ? new Triple(lastValue, lastAtom.getRelation(), value) : new Triple(value, lastAtom.getRelation(), lastValue);
                if (excludedTriples.contains(g) || visitedValues.contains(value)) continue;
                groundings.add(g);
                visitedValues.add(value);
                this.searchTripleExplanation(firstValue, value, firstIndex, lastIndex - 1, variables, excludedTriples, triples, groundings, visitedValues);
                if (groundings.size() < this.bodysize()) {
                    groundings.remove(g);
                    continue;
                }
                break;
            }
        }
    }
}

