/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.structure;

import de.unima.ki.anyburl.Settings;
import de.unima.ki.anyburl.structure.Atom;
import de.unima.ki.anyburl.structure.Body;
import de.unima.ki.anyburl.structure.Path;
import de.unima.ki.anyburl.structure.Rule;
import de.unima.ki.anyburl.structure.RuleAcyclic1;
import de.unima.ki.anyburl.structure.RuleAcyclic2;
import de.unima.ki.anyburl.structure.RuleCyclic;
import de.unima.ki.anyburl.structure.RuleUntyped;
import de.unima.ki.anyburl.structure.RuleZero;
import java.util.ArrayList;

public class RuleFactory {
    public static ArrayList<Rule> getGeneralizations(Path p, boolean onlyXY) {
        RuleUntyped right;
        RuleUntyped rv = new RuleUntyped();
        rv.body = new Body();
        rv.head = p.markers[0] == '+' ? new Atom(p.nodes[0], p.nodes[1], p.nodes[2], true, true) : new Atom(p.nodes[2], p.nodes[1], p.nodes[0], true, true);
        int i = 1;
        while (i < p.markers.length) {
            if (p.markers[i] == '+') {
                rv.body.add(new Atom(p.nodes[i * 2], p.nodes[i * 2 + 1], p.nodes[i * 2 + 2], true, true));
            } else {
                rv.body.add(new Atom(p.nodes[i * 2 + 2], p.nodes[i * 2 + 1], p.nodes[i * 2], true, true));
            }
            ++i;
        }
        ArrayList<Rule> generalizations = new ArrayList<Rule>();
        RuleUntyped leftright = rv.getLeftRightGeneralization();
        if (leftright != null) {
            leftright.replaceAllConstantsByVariables();
            generalizations.add(new RuleCyclic(leftright));
        }
        if (onlyXY) {
            return generalizations;
        }
        RuleUntyped left = rv.getLeftGeneralization();
        if (left != null) {
            if (left.bodysize() == 0) {
                generalizations.add(new RuleZero(left));
            } else {
                RuleUntyped leftFree = left.createCopy();
                if (leftright == null) {
                    leftFree.replaceAllConstantsByVariables();
                }
                left.replaceNearlyAllConstantsByVariables();
                if (!Settings.EXCLUDE_AC2_RULES && leftright == null) {
                    generalizations.add(new RuleAcyclic2(leftFree));
                }
                generalizations.add(new RuleAcyclic1(left));
            }
        }
        if ((right = rv.getRightGeneralization()) != null) {
            if (right.bodysize() == 0) {
                generalizations.add(new RuleZero(right));
            } else {
                RuleUntyped rightFree = right.createCopy();
                if (leftright == null) {
                    rightFree.replaceAllConstantsByVariables();
                }
                right.replaceNearlyAllConstantsByVariables();
                if (!Settings.EXCLUDE_AC2_RULES && leftright == null) {
                    generalizations.add(new RuleAcyclic2(rightFree));
                }
                generalizations.add(new RuleAcyclic1(right));
            }
        }
        return generalizations;
    }
}

