/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.structure;

import de.unima.ki.anyburl.Settings;
import de.unima.ki.anyburl.data.Triple;
import de.unima.ki.anyburl.data.TripleSet;
import de.unima.ki.anyburl.exceptions.RuleFunctionalityBasicSupportOnly;
import de.unima.ki.anyburl.structure.Rule;
import de.unima.ki.anyburl.structure.RuleUntyped;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class RuleZero
extends Rule {
    public RuleZero(RuleUntyped r) {
        super(r);
    }

    @Override
    public void computeScores(TripleSet ts) {
        String c = this.getHead().getConstant();
        String tr = this.getTargetRelation();
        boolean cIsHead = this.getHead().isLeftC();
        ArrayList<Triple> triplesTR = ts.getTriplesByRelation(tr);
        Set<String> triplesTRC = ts.getEntities(tr, c, cIsHead);
        this.predicted = triplesTR.size();
        this.correctlyPredicted = triplesTRC.size();
        this.confidence = (double)this.correctlyPredicted / (double)this.predicted;
    }

    @Override
    public HashSet<String> computeTailResults(String head, TripleSet ts) {
        HashSet<String> results = new HashSet<String>();
        if (this.getHead().isRightC()) {
            results.add(this.getHead().getRight());
        }
        return results;
    }

    @Override
    public HashSet<String> computeHeadResults(String tail, TripleSet ts) {
        HashSet<String> results = new HashSet<String>();
        if (this.getHead().isLeftC()) {
            results.add(this.getHead().getLeft());
        }
        return results;
    }

    @Override
    public double getAppliedConfidence() {
        return Settings.RULE_ZERO_WEIGHT * super.getAppliedConfidence();
    }

    @Override
    public boolean isPredictedX(String leftValue, String rightValue, Triple forbidden, TripleSet ts) {
        throw new RuleFunctionalityBasicSupportOnly();
    }

    @Override
    public boolean isRefinable() {
        return false;
    }

    @Override
    public Triple getRandomValidPrediction(TripleSet ts) {
        throw new RuleFunctionalityBasicSupportOnly();
    }

    @Override
    public Triple getRandomInvalidPrediction(TripleSet ts) {
        throw new RuleFunctionalityBasicSupportOnly();
    }

    @Override
    public ArrayList<Triple> getPredictions(TripleSet ts) {
        throw new RuleFunctionalityBasicSupportOnly();
    }

    @Override
    public boolean isSingleton(TripleSet triples) {
        throw new RuleFunctionalityBasicSupportOnly();
    }

    @Override
    public HashSet<Triple> getTripleExplanation(String head, String tail, HashSet<Triple> blockedTriples, TripleSet ts) {
        HashSet<Triple> groundings = new HashSet<Triple>();
        Triple prediction = new Triple(head, this.getTargetRelation(), tail);
        if (blockedTriples.contains(prediction)) {
            return groundings;
        }
        if (this.isXRule() && tail.equals(this.getHead().getRight())) {
            groundings.add(prediction);
            return groundings;
        }
        if (this.isYRule() && head.equals(this.getHead().getLeft())) {
            groundings.add(prediction);
            return groundings;
        }
        return groundings;
    }

    @Override
    public int[] computeScores(Rule that, TripleSet triples) {
        return new int[2];
    }
}

