/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.threads;

import de.unima.ki.anyburl.Settings;
import de.unima.ki.anyburl.algorithm.RuleEngine;
import de.unima.ki.anyburl.data.Triple;
import de.unima.ki.anyburl.data.TripleSet;
import de.unima.ki.anyburl.structure.Rule;
import java.util.ArrayList;
import java.util.HashMap;

public class Predictor
extends Thread {
    private TripleSet testSet;
    private TripleSet trainingSet;
    private TripleSet validationSet;
    private int k;
    private HashMap<String, ArrayList<Rule>> relation2Rules4Prediction;

    public Predictor(TripleSet testSet, TripleSet trainingSet, TripleSet validationSet, int k, HashMap<String, ArrayList<Rule>> relation2Rules4Prediction) {
        this.testSet = testSet;
        this.trainingSet = trainingSet;
        this.validationSet = validationSet;
        this.k = k;
        this.relation2Rules4Prediction = relation2Rules4Prediction;
    }

    @Override
    public void run() {
        Triple triple = RuleEngine.getNextPredictionTask();
        while (triple != null) {
            if (Settings.AGGREGATION_ID == 1) {
                RuleEngine.predictMax(this.testSet, this.trainingSet, this.validationSet, this.k, this.relation2Rules4Prediction, triple);
            }
            if (Settings.AGGREGATION_ID == 3) {
                RuleEngine.predictNoisyOr(this.testSet, this.trainingSet, this.validationSet, this.k, this.relation2Rules4Prediction, triple);
            }
            triple = RuleEngine.getNextPredictionTask();
        }
    }
}

